package ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class CheckCardBindingStatusTask extends OnetimeTaskSupport<CheckCardBindingStatusTask.Parameters> {
    private CardBindingChecker cardBindingChecker;

    public CheckCardBindingStatusTask(CardBindingChecker cardBindingChecker) {
        super(Parameters.class);
        this.cardBindingChecker = cardBindingChecker;
    }

    public CheckCardBindingStatusTask(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        cardBindingChecker.checkCardBindingStatus(parameters.getBindingId());
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CHECK_TRUST_PAYMENTS;
    }

    @Override
    public int priority() {
        return 0;
    }

    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final UUID bindingId;
    }
}
