package ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks;

import java.util.Currency;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoPayManager;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GroupAutoBillingTask extends OnetimeTaskSupport<GroupAutoBillingTask.Parameters> {
    private AutoPayManager autoPayManager;

    public GroupAutoBillingTask(Long clientId, Currency currency) {
        super(new GroupAutoBillingTask.Parameters(clientId, currency.getCurrencyCode()));
    }

    public GroupAutoBillingTask(AutoPayManager autoPayManager) {
        super(GroupAutoBillingTask.Parameters.class);
        this.autoPayManager = autoPayManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        autoPayManager.chargeRegularAutoPayment(parameters.getClientId(),
                Currency.getInstance(parameters.getCurrency()));
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.AUTO_CHARGE_PAYMENTS;
    }

    @Override
    public int priority() {
        return 0;
    }

    public Duration timeout() {
        return Duration.standardMinutes(2);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final Long clientId;
        private final String currency;
    }
}
