package ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks;

import java.util.Currency;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoResurrectionPayManager;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class GroupAutoReBillingTask  extends OnetimeTaskSupport<GroupAutoReBillingTask.Parameters> {
    private AutoResurrectionPayManager autoResurrectionPayManager;

    public GroupAutoReBillingTask(Long clientId, Currency currency) {
        super(new GroupAutoReBillingTask.Parameters(clientId, currency.getCurrencyCode()));
    }

    public GroupAutoReBillingTask(AutoResurrectionPayManager autoResurrectionPayManager) {
        super(GroupAutoReBillingTask.Parameters.class);
        this.autoResurrectionPayManager = autoResurrectionPayManager;
    }

    @Override
    protected void execute(GroupAutoReBillingTask.Parameters parameters, ExecutionContext context) throws Exception {
        autoResurrectionPayManager.chargeResurrectionAutoPayment(parameters.getClientId(), Currency.getInstance(parameters.getCurrency()));
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.AUTO_CHARGE_PAYMENTS;
    }

    @Override
    public int priority() {
        return 0;
    }

    public Duration timeout() {
        return Duration.standardMinutes(2);
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final Long clientId;
        private final String currency;
    }
}
