package ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class UpdateClientBalanceTask extends OnetimeTaskSupport<UpdateClientBalanceTask.Parameters> {

    private ClientBalanceCalculator clientBalanceCalculator;

    public UpdateClientBalanceTask(Long clientId) {
        super(new UpdateClientBalanceTask.Parameters(clientId));
    }

    public UpdateClientBalanceTask(ClientBalanceCalculator clientBalanceCalculator) {
        super(UpdateClientBalanceTask.Parameters.class);
        this.clientBalanceCalculator = clientBalanceCalculator;
    }

    @Override
    protected void execute(UpdateClientBalanceTask.Parameters parameters, ExecutionContext context) {
        clientBalanceCalculator.updateClientBalance(parameters.clientId);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 5);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.REGULAR;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return UpdateClientBalanceTask.Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final Long clientId;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<UpdateClientBalanceTask.Parameters,
                        UpdateClientBalanceTask.Parameters> {
            @Override
            public Class<UpdateClientBalanceTask.Parameters> getActiveUniqueIdentifierClass() {
                return UpdateClientBalanceTask.Parameters.class;
            }

            @Override
            public UpdateClientBalanceTask.Parameters convert(UpdateClientBalanceTask.Parameters parameters) {
                return parameters;
            }
        }
    }
}
