package ru.yandex.chemodan.app.psbilling.core.billing.users;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

public class CheckRefundTask extends OnetimeTaskSupport<CheckRefundTask.Parameters> {

    private TrustRefundService trustRefundService;

    public CheckRefundTask(TrustRefundService trustRefundService) {
        super(CheckRefundTask.Parameters.class);
        this.trustRefundService = trustRefundService;
    }

    public CheckRefundTask(UUID refundId) {
        super(new CheckRefundTask.Parameters(refundId.toString()));
    }

    @Override
    protected void execute(CheckRefundTask.Parameters parameters, ExecutionContext context) {
        trustRefundService.checkRefund(UUID.fromString(parameters.getRefundId()));
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), 5);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CHECK_TRUST_PAYMENTS;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return CheckRefundTask.Parameters.Converter.class;
    }


    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters {
        private final String refundId;

        public static class Converter implements
                ActiveUniqueIdentifierConverter<CheckRefundTask.Parameters, CheckRefundTask.Parameters>
        {
            @Override
            public Class<CheckRefundTask.Parameters> getActiveUniqueIdentifierClass() {
                return CheckRefundTask.Parameters.class;
            }

            @Override
            public CheckRefundTask.Parameters convert(CheckRefundTask.Parameters parameters) {
                return parameters;
            }
        }
    }

}
