package ru.yandex.chemodan.app.psbilling.core.billing.users;

import java.util.UUID;

import javax.annotation.Nullable;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.joda.time.Duration;

import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.entities.users.Order;
import ru.yandex.chemodan.app.psbilling.core.synchronization.PsBillingQueueNames;
import ru.yandex.chemodan.app.psbilling.core.users.UserService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.bazinga.YcridOnetimeTaskSupport;
import ru.yandex.chemodan.bazinga.YcridTaskParameters;
import ru.yandex.commune.bazinga.scheduler.ActiveUidBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDropType;
import ru.yandex.commune.bazinga.scheduler.ActiveUidDuplicateBehavior;
import ru.yandex.commune.bazinga.scheduler.ActiveUniqueIdentifierConverter;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author friendlyevil
 */
public class UserUpgradeTask extends YcridOnetimeTaskSupport<UserUpgradeTask.Parameters> {
    private UserServiceManager userServiceManager;
    private OrderDao orderDao;

    public UserUpgradeTask(UUID userServiceUpgradeToId, UUID orderUpgradeToId,
                           UUID userServiceUpgradeFromId, UUID orderUpgradeFromId) {
        super(new Parameters(userServiceUpgradeToId.toString(), orderUpgradeToId.toString(),
                userServiceUpgradeFromId.toString(), orderUpgradeFromId.toString()));
    }

    public UserUpgradeTask(UserServiceManager userServiceManager, OrderDao orderDao) {
        super(Parameters.class);
        this.userServiceManager = userServiceManager;
        this.orderDao = orderDao;
    }

    @Override
    protected void doExecute(Parameters parameters, ExecutionContext context) {
        UserService userServiceUpgradeFrom = userServiceManager.findById(UUID.fromString(parameters.getUserServiceUpgradeFromId()));
        UserService userServiceUpgradeTo = userServiceManager.findById(UUID.fromString(parameters.getUserServiceUpgradeToId()));
        Order orderUpgradeFrom = orderDao.findById(UUID.fromString(parameters.getOrderUpgradeFromId()));
        Order orderUpgradeTo = orderDao.findById(UUID.fromString(parameters.getOrderUpgradeToId()));

        userServiceManager.upgradeService(userServiceUpgradeTo, orderUpgradeTo, userServiceUpgradeFrom, orderUpgradeFrom, true);
    }

    @Override
    public ReschedulePolicy reschedulePolicy() {
        return new RescheduleConstant(Duration.standardMinutes(1), Integer.MAX_VALUE);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    public TaskQueueName queueName() {
        return PsBillingQueueNames.CHECK_TRUST_PAYMENTS;
    }

    @Override
    public ActiveUidBehavior activeUidBehavior() {
        return new ActiveUidBehavior(ActiveUidDropType.WHEN_RUNNING, ActiveUidDuplicateBehavior.DO_NOTHING);
    }

    @Nullable
    @Override
    public Class<? extends ActiveUniqueIdentifierConverter<?, ?>> getActiveUidConverter() {
        return UserUpgradeTask.Parameters.Converter.class;
    }

    @BenderBindAllFields
    @AllArgsConstructor
    @Data
    public static class Parameters extends YcridTaskParameters {
        private final String userServiceUpgradeToId;
        private final String orderUpgradeToId;
        private final String userServiceUpgradeFromId;
        private final String orderUpgradeFromId;

        public static class Converter implements ActiveUniqueIdentifierConverter<Parameters, Parameters> {

            @Override
            public Class<Parameters> getActiveUniqueIdentifierClass() {
                return Parameters.class;
            }

            @Override
            public Parameters convert(Parameters parameters) {
                return parameters;
            }
        }
    }
}
