package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.BucketContentDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialDefinitionDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialUsageDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserInfoDao;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.BucketContentManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserInfoService;
import ru.yandex.chemodan.app.psbilling.core.util.LockService;
import ru.yandex.inside.geobase.Geobase;
import ru.yandex.inside.geobase.Geobase6;
import ru.yandex.inside.passport.blackbox2.Blackbox2;
import ru.yandex.misc.io.file.File2;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class
})
public class CommonServicesConfig {
    @Bean
    public BucketContentManager bucketContentManager(BucketContentDao bucketContentDao,
                                                     @Value("${ps-billing.bucket.reread.timeout-mills}") long delayMillis) {
        return new BucketContentManager(delayMillis, bucketContentDao);
    }

    @Bean
    public TrialService trialService(TrialDefinitionDao trialDefinitionDao, TrialUsageDao trialUsageDao) {
        return new TrialService(trialDefinitionDao, trialUsageDao);
    }

    @Bean
    public Geobase geobase(@Value("${geobase.binary.path:-/var/cache/geobase/geodata6.bin}") String geodataBinary,
                           @Value("${geobase.enabled:-true}") boolean geobaseEnabled) {
        if (!geobaseEnabled || !new File2(geodataBinary).exists()) {
            return null;
        }
        return new Geobase6(geodataBinary);
    }

    @Bean
    public LockService lockService(UserInfoDao userInfoDao, GroupDao groupDao, OrderDao orderDao,
                                   UserInfoService userInfoService,
                                   TransactionTemplate transactionTemplate) {
        return new LockService(userInfoDao, groupDao, orderDao, userInfoService, transactionTemplate);
    }

    @Bean
    public UserInfoService userInfoService(UserInfoDao userInfoDao, Blackbox2 blackbox2, Geobase geobase) {
        return new UserInfoService(userInfoDao, blackbox2, geobase);
    }

    @Bean
    public Settings settings() {
        return new Settings();
    }

    @Bean
    public FeatureFlags featureFlags() {
        return new FeatureFlags();
    }
}
