package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialDefinitionDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductSetDao;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.products.SpringExpressionEvaluator;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.v2.GroupPromoService;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingDirectoryConfiguration.class,
        PromoConfiguration.class,
        UserProductConfiguration.class
})

public class GroupProductConfiguration {


    @Bean
    public GroupProductManager groupProductManager(ProductSetDao productSetDao, ProductLineDao productLineDao,
                                                   TextsManager textsManager, PromoService promoService,
                                                   SpringExpressionEvaluator springExpressionEvaluator,
                                                   UserProductManager userProductManager,
                                                   GroupProductDao groupProductDao,
                                                   TrialDefinitionDao trialDefinitionDao,
                                                   FeatureFlags featureFlags,
                                                   GroupPromoService groupPromoService,
                                                   GroupServiceDao groupServiceDao) {
        return new GroupProductManager(productSetDao, productLineDao, groupServiceDao, textsManager, promoService,
                groupProductDao, trialDefinitionDao, userProductManager,
                springExpressionEvaluator, featureFlags, groupPromoService);
    }
}
