package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.FeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.OptionalFeaturesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.BucketContentManager;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.promos.v2.GroupPromoUsedService;
import ru.yandex.chemodan.app.psbilling.core.staff.YandexStaffService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServiceTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationServiceDecorator;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationServiceImpl;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationServiceOld;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.actualizers.GroupServiceActualizerFactory;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.util.LockService;
import ru.yandex.chemodan.directory.client.DirectoryClient;


@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        PsBillingBazingaClientConfiguration.class,
        PsBillingDirectoryConfiguration.class,
        PsBillingSynchronizersConfiguration.class,
        PsBillingStaffConfiguration.class,
        GroupProductConfiguration.class,
        CommonServicesConfig.class
})

public class GroupServicesConfiguration {

    @Bean
    public GroupServicesActualizationServiceOld groupServicesActualizationServiceOld(
            GroupProductDao groupProductDao,
            ProductFeatureDao productFeatureDao,
            ProductTemplateFeatureDao productTemplateFeatureDao,
            DirectoryClient directoryClient,
            GroupServiceDao groupServiceDao,
            GroupDao groupDao,
            TaskScheduler taskScheduler,
            GroupServiceTableSynchronizer groupServiceTableSynchronizer,
            YandexStaffService yandexStaffService,
            FeatureFlags featureFlags) {
        return new GroupServicesActualizationServiceOld(groupProductDao, productFeatureDao,
                productTemplateFeatureDao, directoryClient,
                groupServiceTableSynchronizer, taskScheduler, groupDao,
                groupServiceDao, yandexStaffService, featureFlags);
    }

    @Bean
    public GroupServicesActualizationServiceImpl groupServicesActualizationServiceImpl(
            GroupServiceDao groupServiceDao,
            GroupDao groupDao,
            GroupServiceTableSynchronizer groupServiceTableSynchronizer,
            GroupServiceActualizerFactory groupServiceActualizerFactory) {
        return new GroupServicesActualizationServiceImpl(
                groupServiceTableSynchronizer, groupDao,
                groupServiceDao, groupServiceActualizerFactory);
    }

    @Bean
    public GroupServicesActualizationService groupServicesActualizationService(
            FeatureFlags featureFlags,
            GroupServicesActualizationServiceImpl groupServicesActualizationServiceImpl,
            GroupServicesActualizationServiceOld groupServicesActualizationServiceOld) {
        return new GroupServicesActualizationServiceDecorator(featureFlags,
                groupServicesActualizationServiceImpl,
                groupServicesActualizationServiceOld);
    }

    @Bean
    public GroupServiceActualizerFactory groupServiceActualizerFactory(
        GroupProductDao groupProductDao,
        ProductFeatureDao productFeatureDao,
        ProductTemplateFeatureDao productTemplateFeatureDao,
        DirectoryService directoryService,
        GroupServiceTableSynchronizer tablesSynchronizer,
        TaskScheduler taskScheduler,
        GroupDao groupDao,
        GroupServiceDao groupServiceDao,
        YandexStaffService yandexStaffService,
        FeatureFlags featureFlags){
        return new GroupServiceActualizerFactory(groupProductDao, productFeatureDao, productTemplateFeatureDao,
                directoryService, tablesSynchronizer, taskScheduler, groupDao, groupServiceDao, yandexStaffService,
                featureFlags);
    }

    @Bean
    public GroupServicesManager groupServicesManager(
            GroupServiceDao groupServiceDao,
             LockService lockService,
             GroupServicesActualizationService groupServicesActualizationService,
             TrialService trialService,
             GroupServicePriceOverrideDao groupServicePriceOverrideDao,
             GroupProductManager groupProductManager,
             BucketContentManager bucketContentManager,
             TaskScheduler taskScheduler,
             GroupDao groupDao,
             GroupPromoUsedService groupPromoUsedService
    ) {
        return new GroupServicesManager(
                groupServiceDao,
                groupServicesActualizationService,
                lockService,
                trialService,
                groupProductManager,
                groupServicePriceOverrideDao,
                bucketContentManager,
                groupDao,
                taskScheduler,
                groupPromoUsedService
        );
    }


    @Bean
    public OptionalFeaturesManager optionalFeaturesService(GroupServicesManager groupServicesManager,
                                                           GroupProductManager groupProductManager,
                                                           GroupServiceDao groupServiceDao,
                                                           FeatureDao featureDao) {
        return new OptionalFeaturesManager(groupServicesManager, groupProductManager, groupServiceDao, featureDao);
    }
}
