package ru.yandex.chemodan.app.psbilling.core.config;

import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoResurrectionPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.DistributionPlatformCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.distributionplatform.DistributionPlatformTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.CardDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.DistributionPlatformCalculationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.DistributionPlatformTransactionsDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceMemberDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionCalculationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionsDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.billing.ClientBalanceDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.dynproperties.DynamicProperty;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        PsBillingBazingaClientConfiguration.class,
        YtConfiguration.class,
        PsBillingBalanceConfiguration.class,
        MailSendingConfiguration.class,
        GroupServicesConfiguration.class
})
public class GroupsBillingConfiguration {
    private final DynamicProperty<Integer> exportBatchSizeDp = new DynamicProperty<>(
            "ps-billing-export-distribution-platform-transactions-batch", 5000);
    private final DynamicProperty<Integer> exportBatchSizeGs = new DynamicProperty<>(
            "ps-billing-export-transactions-batch", 5000);

    @Bean
    public GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService(
            GroupServiceDao groupServiceDao, BazingaTaskManager bazingaTaskManager, GroupProductDao groupProductDao,
            GroupServiceTransactionCalculationDao groupServiceTransactionCalculationDao,
            GroupServiceTransactionsExportService groupServiceTransactionsExportService,
            GroupServicePriceOverrideDao groupServicePriceOverrideDao,
            GroupServiceTransactionsDao groupServiceTransactionsDao, TransactionTemplate transactionTemplate,
            TaskScheduler taskScheduler
    ) {
        return new GroupServiceTransactionsCalculationService(bazingaTaskManager, groupServiceDao, groupProductDao,
                groupServiceTransactionsDao, groupServiceTransactionCalculationDao,
                groupServiceTransactionsExportService, groupServicePriceOverrideDao,
                transactionTemplate, taskScheduler);
    }

    @Bean
    public GroupServiceTransactionsExportService groupServicesTransactionsExportService(
            GroupServiceTransactionsDao groupServiceTransactionsDao, @Value("${balance.service-id}") Integer serviceId,
            GroupServiceTransactionCalculationDao groupServiceTransactionCalculationDao,
            BazingaTaskManager bazingaTaskManager,
            YtExportSettings groupServicesPrimaryExportSettings,
            YtExportSettings groupServicesSecondaryExportSettings) {
        return new GroupServiceTransactionsExportService(serviceId, groupServiceTransactionsDao,
                groupServiceTransactionCalculationDao, bazingaTaskManager, groupServicesPrimaryExportSettings,
                groupServicesSecondaryExportSettings, exportBatchSizeDp::get);
    }


    @Bean
    public DistributionPlatformTransactionsExportService distributionPlatformTransactionsExportService(
            BazingaTaskManager bazingaTaskManager,
            YtExportSettings distributionPlatformPrimaryExportSettings,
            YtExportSettings distributionPlatformSecondaryExportSettings,
            DistributionPlatformTransactionsDao distributionPlatformTransactionsDao,
            DistributionPlatformCalculationDao distributionPlatformCalculationDao,
            TransactionTemplate transactionTemplate) {
        return new DistributionPlatformTransactionsExportService(bazingaTaskManager,
                distributionPlatformPrimaryExportSettings,
                distributionPlatformSecondaryExportSettings, distributionPlatformTransactionsDao,
                distributionPlatformCalculationDao,
                transactionTemplate, exportBatchSizeGs::get);
    }

    @Bean
    public GroupBillingService groupBillingService(GroupDao groupDao, GroupServicesManager groupServicesManager,
                                                   BalanceService balanceService,
                                                   GroupServiceDao groupServiceDao,
                                                   GroupProductManager groupProductManager,
                                                   AmazonS3 mdsAmazonS3,
                                                   GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
                                                   ClientBalanceCalculator clientBalanceCalculator,
                                                   ClientBalanceDao clientBalanceDao,
                                                   TaskScheduler taskScheduler,
                                                   GroupBalanceService groupBalanceService,
                                                   GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService,
                                                   CardDao cardDao,
                                                   GroupsManager groupsManager,
                                                   FeatureFlags featureFlags,
                                                   @Value("${s3.invoices.bucket_name}") String bucketName,
                                                   @Value("${s3.invoices.path_in_bucket}") String pathInBucket) {
        return new GroupBillingService(balanceService, groupDao, groupServiceDao,
                groupServicesManager, groupProductManager, groupTrustPaymentRequestDao, clientBalanceCalculator,
                clientBalanceDao, taskScheduler, groupBalanceService, groupServiceTransactionsCalculationService,
                cardDao, groupsManager, featureFlags, mdsAmazonS3, bucketName, pathInBucket);
    }

    @Bean
    public AmazonS3 mdsAmazonS3(@Value("${s3.private.access_key}") String accessKey,
                                @Value("${s3.private.secret_access_key}") String accessSecretKey,
                                @Value("${s3.private.api_endpoint}") String url) {
        return AmazonS3ClientBuilder.standard()
                .withCredentials(new AWSStaticCredentialsProvider(new BasicAWSCredentials(accessKey, accessSecretKey)))
                .withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(url, null))
                .build();
    }

    @Bean
    public DistributionPlatformCalculationService distributionPlatformCalculationService(GroupDao groupDao,
                                                                                         TaskScheduler taskScheduler,
                                                                                         BalanceService balanceService,
                                                                                         DistributionPlatformTransactionsDao distributionPlatformTransactionsDao,
                                                                                         GroupServiceTransactionsDao groupServiceTransactionsDao,
                                                                                         DistributionPlatformCalculationDao distributionPlatformCalculationDao,
                                                                                         TransactionTemplate transactionTemplate) {
        return new DistributionPlatformCalculationService(groupDao, taskScheduler, balanceService,
                distributionPlatformTransactionsDao, groupServiceTransactionsDao, distributionPlatformCalculationDao,
                transactionTemplate);
    }


    @Bean
    public ClientBalanceCalculator clientBalanceCalculator(ClientBalanceDao clientBalanceDao,
                                                           GroupServiceDao groupServiceDao,
                                                           GroupServiceMemberDao groupServiceMemberDao,
                                                           GroupProductManager groupProductManager,
                                                           GroupBalanceService groupBalanceService,
                                                           GroupServiceTransactionsDao groupServiceTransactionsDao,
                                                           DirectoryService directoryService,
                                                           GroupDao groupDao,
                                                           TaskScheduler taskScheduler,
                                                           Settings settings,
                                                           GroupServicePriceOverrideDao groupServicePriceOverrideDao) {
        return new ClientBalanceCalculator(clientBalanceDao,
                groupServiceDao,
                groupServiceMemberDao,
                groupProductManager,
                groupBalanceService,
                groupServiceTransactionsDao,
                directoryService,
                groupDao,
                taskScheduler, settings, groupServicePriceOverrideDao);
    }

    @Bean
    public AutoPayManager autoPayManager(ClientBalanceDao clientBalanceDao,
                                         Settings settings,
                                         GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
                                         GroupBillingService groupBillingService,
                                         GroupDao groupDao,
                                         ClientBalanceCalculator clientBalanceCalculator,
                                         CardDao cardDao,
                                         GroupServiceDao groupServiceDao,
                                         GroupProductManager groupProductManager,
                                         BalanceService balanceService,
                                         TaskScheduler taskScheduler,
                                         FeatureFlags featureFlags,
                                         DirectoryService directoryService) {
        return new AutoPayManager(clientBalanceDao, settings, groupTrustPaymentRequestDao,
                groupBillingService, groupDao, clientBalanceCalculator, cardDao,
                groupServiceDao, groupProductManager, balanceService,
                taskScheduler, featureFlags, directoryService);
    }

    @Bean
    public AutoResurrectionPayManager autoResurrectionPayManager(
            ClientBalanceDao clientBalanceDao,
            Settings settings,
            GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
            GroupBillingService groupBillingService,
            GroupDao groupDao,
            ClientBalanceCalculator clientBalanceCalculator,
            CardDao cardDao,
            GroupServiceDao groupServiceDao,
            GroupProductManager groupProductManager,
            BalanceService balanceService,
            TaskScheduler taskScheduler,
            FeatureFlags featureFlags,
            GroupServicesManager groupServicesManager,
            DirectoryService directoryService,
            GroupServicePriceOverrideDao groupServicePriceOverrideDao) {
        return new AutoResurrectionPayManager(clientBalanceDao, settings,
                groupTrustPaymentRequestDao, groupBillingService,
                groupDao, clientBalanceCalculator, cardDao, groupServiceDao,
                groupProductManager, balanceService, taskScheduler, featureFlags,
                groupServicesManager, directoryService, groupServicePriceOverrideDao);
    }
}
