package ru.yandex.chemodan.app.psbilling.core.config;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupPartnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductOwnerDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.util.LockService;
import ru.yandex.chemodan.directory.client.DirectoryClient;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        GroupServicesConfiguration.class,
        GroupsBillingConfiguration.class
})
public class GroupsConfiguration {
    @Bean
    public GroupsManager groupsManager(GroupDao groupDao, GroupServicePriceOverrideDao groupServicePriceOverrideDao,
                                       @Value("${balance.create-offer-params.payment-term}") int gracePeriod,
                                       ProductOwnerDao productOwnerDao,
                                       GroupServicesManager groupServicesManager, LockService lockService,
                                       GroupProductManager groupProductManager,
                                       DirectoryClient directoryClient,
                                       ClientBalanceCalculator clientBalanceCalculator,
                                       GroupPartnerDao groupPartnerDao) {
        return new GroupsManager(groupDao, groupProductManager, productOwnerDao, groupServicePriceOverrideDao,
                groupServicesManager, lockService, Duration.standardDays(gracePeriod), directoryClient,
                clientBalanceCalculator, groupPartnerDao);
    }
}
