package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.DefaultErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.MailErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.MpfsErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.MpfsSkipNotInitializedErrorProcessor;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({ProdBlackboxContextConfiguration.class})
public class MailProcessConfiguration {
    @Bean
    public DefaultErrorProcessor defaultErrorProcessor(Blackbox2 blackbox2) {
        return new DefaultErrorProcessor(blackbox2);
    }

    @Bean
    public MpfsErrorProcessor mpfsErrorProcessor(Blackbox2 blackbox2) {
        return new MpfsErrorProcessor(blackbox2);
    }

    @Bean
    public MpfsSkipNotInitializedErrorProcessor mpfsSkipNotInitializedErrorProcessor(Blackbox2 blackbox2) {
        return new MpfsSkipNotInitializedErrorProcessor(blackbox2);
    }

    @Bean
    public MailErrorProcessor mailErrorProcessor(Blackbox2 blackbox2) {
        return new MailErrorProcessor(blackbox2);
    }
}
