package ru.yandex.chemodan.app.psbilling.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.mail.SenderClient;
import ru.yandex.chemodan.app.psbilling.core.mail.configuration.GlobalMailConfiguration;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.web.JacksonContextConfiguration;

@Configuration
@Import({JacksonContextConfiguration.class})
public class MailSendingConfiguration {

    @Bean
    @OverridableValuePrefix("sender")
    public HttpClientConfigurator senderHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public HttpClient senderHttpClient(HttpClientConfigurator senderHttpClientConfigurator) {
        return senderHttpClientConfigurator.configure();
    }

    @Bean
    public SenderClient senderClient(HttpClient senderHttpClient, ObjectMapper objectMapper,
                                     @Value("${sender.base_url}") String baseUrl,
                                     @Value("${sender.blackbox.env:-}") String blackboxEnv) {
        return new SenderClient(senderHttpClient, objectMapper, baseUrl,
                Option.ofNullable(blackboxEnv).filter(StringUtils::isNotBlank));
    }


    @Bean
    public GlobalMailConfiguration senderConfigurationManager() {
        return new GlobalMailConfiguration();
    }
}
