package ru.yandex.chemodan.app.psbilling.core.config;

import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductOwnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.texts.TankerKeyDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.mail.SenderClient;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.B2bJustPaidOrEndTrialSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.BecameFreeSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.IssueAnInvoiceSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.JustPaidSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.SenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.SubscriptionCancelledSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.SubscriptionHasBeenEndedSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.SubscriptionHasNotBeenPaidSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.TrialEndsSoonSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.TermsResolver;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.mail.TransactionalEmailExecutor;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({GroupsBillingConfiguration.class,
        PsBillingBalanceConfiguration.class,
        JacksonContextConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingUtilsConfiguration.class})
public class MailSendingDataConfiguration {

    @Bean
    public DateResolver dateResolver(ObjectMapper objectMapper, UserTimezoneHelper userTimezoneHelper) throws IOException {
        return new DateResolver(objectMapper, userTimezoneHelper);
    }

    @Bean
    public TermsResolver termsResolver(ObjectMapper objectMapper) throws IOException {
        return new TermsResolver(objectMapper);
    }

    @Bean
    public SenderDataProvider becameFreeSenderDataProvider(GroupDao groupDao, DateResolver dateResolver,
                                                           Blackbox2 blackbox2,
                                                           GroupBillingService groupBillingService,
                                                           BalanceService balanceService,
                                                           TermsResolver termsResolver, GroupsManager groupsManager,
                                                           FeatureFlags featureFlags) {
        return new BecameFreeSenderDataProvider(groupDao, dateResolver, blackbox2, groupBillingService, balanceService,
                termsResolver, groupsManager, featureFlags);
    }

    @Bean
    public SenderDataProvider issueAnInvoiceSenderDataProvider(GroupDao groupDao, DateResolver dateResolver,
                                                               Blackbox2 blackbox2,
                                                               GroupBillingService groupBillingService,
                                                               BalanceService balanceService,
                                                               TermsResolver termsResolver,
                                                               GroupsManager groupsManager,
                                                               FeatureFlags featureFlags) {
        return new IssueAnInvoiceSenderDataProvider(groupDao, dateResolver, blackbox2, groupBillingService,
                balanceService, termsResolver, groupsManager, featureFlags);
    }

    @Bean
    public SenderDataProvider b2bJustPaidOrEndTrialSenderDataProvider(Blackbox2 blackbox2,
                                                                      GroupDao groupDao, DateResolver dateResolver,
                                                                      GroupProductDao groupProductDao,
                                                                      UserProductDao userProductDao,
                                                                      TankerKeyDao tankerKeyDao,
                                                                      BalanceService balanceService,
                                                                      ProductOwnerDao productOwnerDao,
                                                                      UserProductManager userProductManager,
                                                                      GroupsManager groupsManager,
                                                                      GroupServiceDao groupServiceDao,
                                                                      FeatureFlags featureFlags) {
        return new B2bJustPaidOrEndTrialSenderDataProvider(blackbox2, groupDao, dateResolver, groupProductDao,
                userProductDao, tankerKeyDao, balanceService, productOwnerDao, userProductManager, groupsManager,
                groupServiceDao, featureFlags);
    }

    @Bean
    public SenderDataProvider trialEndsSoonSenderDataProvider(Blackbox2 blackbox2, GroupsManager groupsManager,
                                                              ProductOwnerDao productOwnerDao,
                                                              UserProductDao userProductDao,
                                                              BalanceService balanceService, GroupDao groupDao,
                                                              GroupProductDao groupProductDao,
                                                              TankerKeyDao tankerKeyDao, DateResolver dateResolver,
                                                              GroupServicePriceOverrideDao groupServicePriceOverrideDao,
                                                              GroupServiceDao groupServiceDao) {
        return new TrialEndsSoonSenderDataProvider(blackbox2, groupsManager, productOwnerDao, userProductDao,
                balanceService, groupDao, groupProductDao, tankerKeyDao, dateResolver,
                groupServicePriceOverrideDao, groupServiceDao);
    }

    @Bean
    public SenderDataProvider justPaidSenderDataProvider(Blackbox2 blackbox2, GroupsManager groupsManager,
                                                         UserServiceManager userServiceManager,
                                                         UserProductManager userProductManager,
                                                         TermsResolver termsResolver,
                                                         DateResolver dateResolver) {
        return new JustPaidSenderDataProvider(blackbox2, groupsManager, dateResolver, userServiceManager,
                userProductManager, termsResolver);
    }

    @Bean
    public SenderDataProvider subscriptionCancelledSenderDataProvider(Blackbox2 blackbox2, GroupsManager groupsManager,
                                                                      UserServiceManager userServiceManager,
                                                                      DateResolver dateResolver) {
        return new SubscriptionCancelledSenderDataProvider(blackbox2, groupsManager,
                userServiceManager, dateResolver);
    }

    @Bean
    public SenderDataProvider subscriptionHasBeenEndedSenderDataProvider(Blackbox2 blackbox2,
                                                                         GroupsManager groupsManager,
                                                                         UserServiceManager userServiceManager) {
        return new SubscriptionHasBeenEndedSenderDataProvider(blackbox2, groupsManager,
                userServiceManager);
    }

    @Bean
    public SenderDataProvider subscriptionHasNotBeenPaidSenderDataProvider(Blackbox2 blackbox2,
                                                                           GroupsManager groupsManager,
                                                                           UserServiceManager userServiceManager,
                                                                           UserProductManager userProductManager,
                                                                           DateResolver dateResolver) {
        return new SubscriptionHasNotBeenPaidSenderDataProvider(blackbox2, groupsManager,
                userServiceManager, userProductManager, dateResolver);
    }

    @Bean
    public TransactionalEmailExecutor transactionalEmailExecutor(List<SenderDataProvider> senderDataProviders,
                                                                 SenderClient senderClient) {
        return new TransactionalEmailExecutor(senderClient, Cf.x(senderDataProviders));
    }
}
