package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoResurrectionPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.PaymentChecker;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.CardDao;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.TrustCardBindingDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupsManager;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;

@Configuration
@Import({
        GroupsBillingConfiguration.class
})
public class PaymentConfiguration {

    @Bean
    public PaymentChecker paymentChecker(BalanceService balanceService, GroupDao groupDao,
                                         GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
                                         AutoResurrectionPayManager autoResurrectionPayManager,
                                         GroupBillingService groupBillingService, CardBindingChecker cardBindingChecker,
                                         Settings settings) {
        return new PaymentChecker(balanceService, groupDao, groupTrustPaymentRequestDao, autoResurrectionPayManager,
                groupBillingService, cardBindingChecker,settings);
    }

    @Bean
    public CardBindingChecker bindingChecker(BalanceService balanceService,
                                             GroupBillingService groupBillingService,
                                             CardDao cardDao,
                                             GroupsManager groupsManager,
                                             FeatureFlags featureFlags,
                                             TaskScheduler taskScheduler,
                                             TrustCardBindingDao trustCardBindingDao) {
        return new CardBindingChecker(balanceService, groupBillingService, cardDao, groupsManager, featureFlags, taskScheduler, trustCardBindingDao);
    }
}
