package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPricesDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.GroupPromoCodeActivationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.PromoCodeDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.PromoCodeTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.UserPromoCodeDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProductManager;
import ru.yandex.chemodan.app.psbilling.core.products.SpringExpressionEvaluator;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.activator.PromoCodeActivatorFactory;
import ru.yandex.chemodan.app.psbilling.core.promocodes.impl.PromoCodeServiceImpl;
import ru.yandex.chemodan.app.psbilling.core.promocodes.impl.RateLimitPromoCodeServiceDecorator;
import ru.yandex.chemodan.app.psbilling.core.promocodes.length.PromoCodeLengthService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.length.SmartPromoCodeLengthService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerEvaluate;
import ru.yandex.chemodan.app.psbilling.core.promocodes.rule.PromoCodeRuleCheckerFactory;
import ru.yandex.chemodan.app.psbilling.core.promocodes.validation.PromoCodeValidator;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoPayloadParser;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.v2.GroupPromoService;
import ru.yandex.chemodan.app.psbilling.core.promos.v2.GroupPromoUsedService;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.commune.bazinga.BazingaTaskManager;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        PsBillingBazingaClientConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingDirectoryConfiguration.class,
        PsBillingUtilsConfiguration.class
})
public class PromoConfiguration {
    @Bean
    public PromoService promoService(PromoTemplateDao promoTemplateDao,
                                     UserPromoDao userPromoDao,
                                     TaskScheduler taskScheduler,
                                     TextsManager textsManager,
                                     UserTimezoneHelper userTimezoneHelper,
                                     PromoPayloadParser promoPayloadParser,
                                     ProductLineDao productLineDao,
                                     PromoPayloadDao promoPayloadDao) {
        return new PromoService(promoTemplateDao, userPromoDao, textsManager, taskScheduler, userTimezoneHelper,
                promoPayloadParser, productLineDao, promoPayloadDao);
    }

    @Bean
    public GroupPromoService promoForGroupService(
            PromoTemplateDao promoTemplateDao,
            GroupPromoDao groupPromoDao,
            GroupPromoTemplateDao groupPromoTemplateDao,
            UserTimezoneHelper userTimezoneHelper
    ) {
        return new GroupPromoService(
                promoTemplateDao,
                groupPromoDao,
                groupPromoTemplateDao,
                userTimezoneHelper
        );
    }

    @Bean
    public GroupPromoUsedService groupPromoUsedService(
            GroupPromoService groupPromoService,
            GroupProductManager groupProductManager,
            ProductLineDao productLineDao
    ) {
        return new GroupPromoUsedService(
                groupPromoService,
                groupProductManager,
                productLineDao
        );
    }

    @Bean
    public PromoCodeActivatorFactory promoCodeActivatorFactory(
            UserPromoCodeDao userPromoCodeDao,
            UserBillingService userBillingService,
            UserProductManager userProductManager,
            UserServiceManager userServiceManager,
            UserPromoDao userPromoDao,
            PromoService promoService,
            GroupPromoCodeActivationDao groupPromoCodeActivationDao,
            GroupPromoService groupPromoService
    ) {
        return new PromoCodeActivatorFactory(
                userPromoCodeDao,
                userBillingService,
                userProductManager,
                userServiceManager,
                userPromoDao,
                promoService,
                groupPromoCodeActivationDao,
                groupPromoService
        );
    }

    @Bean
    public PromoCodeLengthService lengthService(PromoCodeDao promoCodeDao) {
        return new SmartPromoCodeLengthService(promoCodeDao);
    }

    @Bean(name = PromoCodeService.IMPL)
    public PromoCodeService promoCodeService(
            PromoCodeDao promoCodeDao,
            UserPromoCodeDao userPromoCodeDao,
            GroupPromoCodeActivationDao groupPromoCodeActivationDao,
            PromoTemplateDao promoTemplateDao,
            UserProductPricesDao productPricesDao,
            PromoCodeActivatorFactory activatorFactory,
            TransactionTemplate transactionTemplate,
            BazingaTaskManager bazingaTaskManager,
            PromoCodeLengthService promoCodeLengthService,
            PromoCodeRuleCheckerEvaluate ruleCheckerEvaluate,
            PromoCodeValidator basePromoCodeValidation,
            PromoCodeTemplateDao promoCodeTemplateDao,
            TextsManager textsManager
    ) {

        return new PromoCodeServiceImpl(
                promoCodeDao,
                userPromoCodeDao,
                groupPromoCodeActivationDao,
                promoTemplateDao,
                productPricesDao,
                activatorFactory,
                transactionTemplate,
                bazingaTaskManager,
                promoCodeLengthService,
                ruleCheckerEvaluate,
                basePromoCodeValidation,
                promoCodeTemplateDao
        );
    }

    @Bean
    public PromoCodeValidator promoCodeValidator() {
        return new PromoCodeValidator();
    }

    @Bean
    public PromoCodeRuleCheckerEvaluate promoCodeRuleCheckerEvaluate(
            PromoCodeRuleCheckerFactory promoCodeRuleCheckerFactory,
            SpringExpressionEvaluator evaluateExpression
    ) {
        return new PromoCodeRuleCheckerEvaluate(
                promoCodeRuleCheckerFactory,
                evaluateExpression
        );
    }

    @Bean
    public PromoCodeRuleCheckerFactory promoCodeRuleCheckerFactory(
            GroupServiceDao groupServiceDao,
            GroupProductDao groupProductDao,
            PromoTemplateDao promoTemplateDao,
            DirectoryClient directoryClient
    ) {
        return new PromoCodeRuleCheckerFactory(
                groupServiceDao,
                groupProductDao,
                promoTemplateDao,
                directoryClient
        );
    }

    @Primary
    @Bean(name = PromoCodeService.RATE_LIMITER_DECORATOR)
    public PromoCodeService promoCodeService(
            @Qualifier(PromoCodeService.IMPL) PromoCodeService innerService
    ) {
        return new RateLimitPromoCodeServiceDecorator(innerService);
    }

}
