package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsContextConfigutation;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.bazinga.PgBazingaStorageConfigurationContextConfiguration;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.pg.context.PgBazingaClientContextConfiguration;

@Configuration
@Import({
        PgBazingaClientContextConfiguration.class,
        PgBazingaStorageConfigurationContextConfiguration.class,
        ExperimentsContextConfigutation.class,
        CommonServicesConfig.class
})
public class PsBillingBazingaClientConfiguration {

    @Bean
    public TaskScheduler taskScheduler(ExperimentsManager experimentsManager,
                                       BazingaTaskManager bazingaTaskManager,
                                       FeatureFlags featureFlags) {
        return new TaskScheduler(experimentsManager, bazingaTaskManager, featureFlags);
    }
}
