package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.admin.AdminConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.tasks.TasksExecutionConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.products.ProductLineService;
import ru.yandex.chemodan.app.psbilling.core.util.LanguageService;
import ru.yandex.chemodan.app.psbilling.core.util.impl.BlackboxLanguageService;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({
        TasksExecutionConfiguration.class,
        GroupsConfiguration.class,
        UserServicesConfiguration.class,
        MailProcessConfiguration.class,
        AdminConfiguration.class,
        PaymentConfiguration.class
})
public class PsBillingCoreConfiguration {

    @Bean
    public LanguageService blackboxLanguageService(Blackbox2 blackbox2){
        return new BlackboxLanguageService(blackbox2);
    }

    @Bean
    public ProductLineService productLineService(ProductLineDao productLineDao){
        return new ProductLineService(productLineDao);
    }
}
