package ru.yandex.chemodan.app.psbilling.core.config;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

import ru.yandex.chemodan.app.psbilling.core.dao.cards.CardDao;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.TrustCardBindingDao;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.impl.CardDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.cards.impl.TrustCardBindingDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.features.FeatureCallbackContextDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.GroupServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.impl.FeatureCallbackContextDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.features.impl.GroupServiceFeatureDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.features.impl.UserServiceFeatureDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.BucketContentDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.DistributionPlatformCalculationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.DistributionPlatformTransactionsDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupPartnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceMemberDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServicePriceOverrideDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionCalculationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionsDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialDefinitionDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialUsageDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.billing.ClientBalanceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.BucketContentDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.DistributionPlatformCalculationTasksDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.DistributionPlatformTransactionsDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupPartnerDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupProductDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupServiceDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupServiceMemberDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupServicePriceOverrideDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupServiceTransactionCalculationDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupServiceTransactionsDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.GroupTrustPaymentRequestDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.TrialDefinitionDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.TrialUsageDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.impl.billing.ClientBalanceDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.EmailTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.impl.EmailTemplateDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.impl.SentEmailInfoDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.FeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductOwnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductSetDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductBucketDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPeriodDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPricesDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.FeatureDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductFeatureDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductLineDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductOwnerDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductSetDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductTemplateDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.ProductTemplateFeatureDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.UserProductBucketDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.UserProductDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.UserProductPeriodDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.impl.UserProductPricesDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.GroupPromoCodeActivationDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.PromoCodeDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.PromoCodeTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.UserPromoCodeDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.impl.GroupPromoCodeActivationDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.impl.PromoCodeDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.impl.PromoCodeTemplateDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.impl.UserPromoCodeDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.group.GroupPromoTemplateDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.texts.TankerKeyDao;
import ru.yandex.chemodan.app.psbilling.core.dao.texts.TankerKeyDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.RefundDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserInfoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.impl.OrderDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.users.impl.RefundDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.users.impl.UserInfoDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.users.impl.UserServiceDaoImpl;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.misc.db.masterSlave.spring.MasterSlaveDataSourceTransactionManager;
import ru.yandex.misc.db.postgres.PgBouncerFamiliarTransactionManager;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;


@Configuration
@Import(value = {
        JdbcDatabaseConfiguratorContextConfiguration.class,
        PsBillingDbConfiguration.class
})
@EnableTransactionManagement
public class PsBillingCoreDaoConfiguration {
    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    public TransactionTemplate transactionTemplate(PlatformTransactionManager transactionManager) {
        return new TransactionTemplate(transactionManager);
    }

    @Bean
    public JdbcDatabaseConfigurator psBillingDbConfigurator(DataSourceProperties psBillingDataSourceProperties) {
        return dbConfiguratorConfig.consJdbcConfigurator(psBillingDataSourceProperties);
    }

    @Bean
    public DataSource psBillingDataSource(JdbcDatabaseConfigurator psBillingDbConfigurator) {
        return psBillingDbConfigurator.configureDataSource();
    }

    @Bean
    public MasterSlaveDataSourceTransactionManager txManager(DataSource psBullingDataSource) {
        return new MasterSlaveDataSourceTransactionManager(
                new PgBouncerFamiliarTransactionManager(psBullingDataSource));

    }


    @Bean
    public JdbcTemplate3 psBillingJdbcTemplate(
            JdbcDatabaseConfigurator psBillingDbConfigurator, DataSource psBillingDataSource) {
        return psBillingDbConfigurator.consTemplate(psBillingDataSource);
    }

    @Bean
    public GroupProductDao productDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupProductDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public BucketContentDao bucketContentDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new BucketContentDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupDao groupDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServiceDao groupServiceDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServiceDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServiceMemberDao groupServiceMemberDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServiceMemberDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupPartnerDao groupPartnerDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupPartnerDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserProductDao userProductDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserProductDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public FeatureDao featureDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new FeatureDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductFeatureDao productFeatureDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductFeatureDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserServiceFeatureDao userServiceFeatureDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserServiceFeatureDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductTemplateFeatureDao productTemplateFeatureDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductTemplateFeatureDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductTemplateDao productTemplateDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductTemplateDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServiceFeatureDao groupServiceFeatureDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServiceFeatureDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserServiceDao userServiceDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserServiceDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public FeatureCallbackContextDao featureCallbackContextDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new FeatureCallbackContextDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServiceTransactionsDao groupServiceTransactionsDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServiceTransactionsDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServiceTransactionCalculationDao groupServiceTransactionCalculationDao(
            JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServiceTransactionCalculationDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductLineDao productLineDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductLineDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductSetDao productSetDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductSetDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public TankerKeyDao tankerKeyDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new TankerKeyDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserProductPricesDao userProductPricesDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserProductPricesDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserProductPeriodDao userProductPeriodDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserProductPeriodDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public UserInfoDao userInfoDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new UserInfoDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public ProductOwnerDao productOwnerDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new ProductOwnerDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public CardDao cardDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new CardDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public TrustCardBindingDao trustCardBindingDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new TrustCardBindingDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public OrderDao orderDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new OrderDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public RefundDao refundDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new RefundDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public TrialDefinitionDao trialDefinitionDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new TrialDefinitionDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public TrialUsageDao trialUsageDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new TrialUsageDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupServicePriceOverrideDao groupServicePriceOverrideDao(JdbcTemplate3 psBillingJdbcTemplate) {
        return new GroupServicePriceOverrideDaoImpl(psBillingJdbcTemplate);
    }

    @Bean
    public GroupTrustPaymentRequestDao groupTrustPaymentRequestDao(JdbcTemplate3 jdbcTemplate3) {
        return new GroupTrustPaymentRequestDaoImpl(jdbcTemplate3);
    }

    @Bean
    public UserProductBucketDao userProductBucketDao(JdbcTemplate3 jdbcTemplate3) {
        return new UserProductBucketDaoImpl(jdbcTemplate3);
    }

    @Bean
    public PromoTemplateDao promoTemplateDao(JdbcTemplate3 jdbcTemplate3) {
        return new PromoTemplateDaoImpl(jdbcTemplate3);
    }

    @Bean
    public GroupPromoTemplateDao groupPromoTemplateDao(JdbcTemplate3 jdbcTemplate3) {
        return new GroupPromoTemplateDaoImpl(jdbcTemplate3);
    }

    @Bean
    public PromoPayloadDao promoPayloadDao(JdbcTemplate3 jdbcTemplate3) {
        return new PromoPayloadDaoImpl(jdbcTemplate3);
    }

    @Bean
    public PromoCodeDao promoCodeDao(JdbcTemplate3 jdbcTemplate3) {
        return new PromoCodeDaoImpl(jdbcTemplate3);
    }

    @Bean
    public UserPromoCodeDao userPromoCodeDao(JdbcTemplate3 jdbcTemplate3) {
        return new UserPromoCodeDaoImpl(jdbcTemplate3);
    }

    @Bean
    public PromoCodeTemplateDao promoCodeTemplatesDao(JdbcTemplate3 jdbcTemplate3) {
        return new PromoCodeTemplateDaoImpl(jdbcTemplate3);
    }

    @Bean
    public GroupPromoCodeActivationDao groupPromoCodeActivationDao(JdbcTemplate3 jdbcTemplate3) {
        return new GroupPromoCodeActivationDaoImpl(jdbcTemplate3);
    }

    @Bean
    public EmailTemplateDao emailTemplateDao(JdbcTemplate3 jdbcTemplate3) {
        return new EmailTemplateDaoImpl(jdbcTemplate3);
    }

    @Bean
    public SentEmailInfoDao sentEmailDao(JdbcTemplate3 jdbcTemplate3) {
        return new SentEmailInfoDaoImpl(jdbcTemplate3);
    }

    @Bean
    public UserPromoDao userPromoDao(JdbcTemplate3 jdbcTemplate3) {
        return new UserPromoDaoImpl(jdbcTemplate3);
    }

    @Bean
    public GroupPromoDaoImpl groupPromoDao(JdbcTemplate3 jdbcTemplate3) {
        return new GroupPromoDaoImpl(jdbcTemplate3);
    }

    @Bean
    public DistributionPlatformTransactionsDao distributionPlatformTransactionsDao(
            JdbcTemplate3 jdbcTemplate3,
            @Value("${distribution_platform.product_id}") String productId) {
        return new DistributionPlatformTransactionsDaoImpl(jdbcTemplate3, productId);
    }

    @Bean
    public DistributionPlatformCalculationDao distributionPlatformCalculationTasksDao(JdbcTemplate3 jdbcTemplate3) {
        return new DistributionPlatformCalculationTasksDaoImpl(jdbcTemplate3);
    }

    @Bean
    public ClientBalanceDao clientBalanceDao(JdbcTemplate3 jdbcTemplate3) {
        return new ClientBalanceDaoImpl(jdbcTemplate3);
    }

}
