package ru.yandex.chemodan.app.psbilling.core.config;

import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.directory.DirectoryService;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
})
public class PsBillingDirectoryConfiguration {
    @Bean
    @Qualifier("directory")
    @OverridableValuePrefix("directory")
    public HttpClientConfigurator directoryHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public DirectoryClient directoryClient(@Value("${directory.host}") String host) {
        CloseableHttpClient httpClient = directoryHttpClientConfigurator().createBuilder()
                .multiThreaded()
                .build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "directory");
        RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(wrapped));
        return new DirectoryClient(host, restTemplate);
    }

    @Bean
    public DirectoryService directoryService(DirectoryClient directoryClient, GroupDao groupDao) {
        return new DirectoryService(directoryClient, groupDao);
    }
}
