package ru.yandex.chemodan.app.psbilling.core.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

import ru.yandex.chemodan.app.psbilling.core.staff.YandexStaffService;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.web.JacksonContextConfiguration;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;

@Configuration
@Import({Tvm2BaseContextConfiguration.class, JacksonContextConfiguration.class})
public class PsBillingStaffConfiguration {


    @Bean
    public YandexStaffService yandexStaffService(@Value("${staff.host}") String host, ObjectMapper objectMapper) {
        CloseableHttpClient httpClient = staffHttpConfigurator().createBuilder()
                .multiThreaded()
                .build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "staff");
        RestTemplate restTemplate = new RestTemplate(new HttpComponentsClientHttpRequestFactory(wrapped));
        setObjectMapper(restTemplate, objectMapper);

        return new YandexStaffService(host, restTemplate);
    }


    @Bean
    @OverridableValuePrefix("staff")
    public HttpClientConfigurator staffHttpConfigurator() {
        return new HttpClientConfigurator();
    }

    private void setObjectMapper(RestTemplate restTemplate, ObjectMapper objectMapper) {
        MappingJackson2HttpMessageConverter messageConverter = restTemplate.getMessageConverters().stream()
                .filter(MappingJackson2HttpMessageConverter.class::isInstance)
                .map(MappingJackson2HttpMessageConverter.class::cast)
                .findFirst().orElseThrow(() -> new RuntimeException("MappingJackson2HttpMessageConverter not found"));
        messageConverter.setObjectMapper(objectMapper);
    }
}
