package ru.yandex.chemodan.app.psbilling.core.config;

import java.util.List;

import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.client.RestTemplate;

import ru.yandex.chemodan.app.psbilling.core.dao.features.FeatureCallbackContextDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.GroupServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceMemberDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.FeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.errorprocessors.ErrorProcessor;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.GroupTemplateContextFactory;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.templatecontexts.UserTemplateContextFactory;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember.GroupServiceMemberActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember.GroupServiceMemberTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServiceTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservicefeature.GroupFeaturesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceTableSynchronizer;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature.UserFeaturesActualizationService;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        PsBillingBazingaClientConfiguration.class,
        Tvm2BaseContextConfiguration.class
})
public class PsBillingSynchronizersConfiguration {

    @Bean
    public GroupServiceTableSynchronizer groupServiceTableSynchronizer(
            GroupServiceFeatureDao groupServiceFeatureDao, GroupServiceDao groupServiceDao,
            GroupServiceMemberDao groupServiceMemberDao, TransactionTemplate transactionTemplate,
            BazingaTaskManager bazingaTaskManager) {
        return new GroupServiceTableSynchronizer(
                groupServiceMemberDao, groupServiceFeatureDao, groupServiceDao, transactionTemplate,
                bazingaTaskManager);
    }

    @Bean
    public GroupServiceMemberTableSynchronizer groupServiceMemberTableSynchronizer(UserServiceDao userServiceDao,
            GroupServiceMemberDao groupServiceMemberDao, TransactionTemplate transactionTemplate,
            BazingaTaskManager bazingaTaskManager
    )
    {
        return new GroupServiceMemberTableSynchronizer(
                userServiceDao, groupServiceMemberDao, transactionTemplate, bazingaTaskManager);
    }

    @Bean
    public UserServiceTableSynchronizer userServiceTableSynchronizer(UserServiceDao userServiceDao,
                                                                     UserServiceFeatureDao userServiceFeatureDao,
                                                                     TransactionTemplate transactionTemplate,
                                                                     BazingaTaskManager bazingaTaskManager) {
        return new UserServiceTableSynchronizer(
                userServiceFeatureDao, userServiceDao, transactionTemplate, bazingaTaskManager);
    }

    @Bean
    public GroupTemplateContextFactory groupTemplateContextFactory(GroupDao groupDao) {
        return new GroupTemplateContextFactory(groupDao);
    }

    @Bean
    public UserTemplateContextFactory userTemplateContextFactory() {
        return new UserTemplateContextFactory();
    }

    @Bean
    public GroupServiceMemberActualizationService groupServiceMemberActualizationService(
            GroupServiceMemberTableSynchronizer groupServiceMemberTableSynchronizer, UserProductDao userProductDao,
            BazingaTaskManager bazingaTaskManager, GroupServiceMemberDao groupServiceMemberDao
    ) {
        return new GroupServiceMemberActualizationService(groupServiceMemberTableSynchronizer, userProductDao,
                groupServiceMemberDao, bazingaTaskManager);
    }

    @Bean
    public UserServiceActualizationService userServiceActualizationService(BazingaTaskManager bazingaTaskManager,
                                                                           UserServiceTableSynchronizer userServiceTableSynchronizer,
                                                                           ProductFeatureDao productFeatureDao,
                                                                           UserServiceDao userServiceDao,
                                                                           ProductTemplateFeatureDao productTemplateFeatureDao
    ) {
        return new UserServiceActualizationService(userServiceTableSynchronizer, bazingaTaskManager, productFeatureDao,
                userServiceDao, productTemplateFeatureDao);
    }

    @Bean
    public UserFeaturesActualizationService userFeaturesSynchronizationService(FeatureDao featureDao, Tvm2 tvm2,
                                                                               ProductFeatureDao productFeatureDao,
                                                                               @FeaturesSynchronize RestTemplate externalSystemsRestTemplate,
                                                                               UserServiceFeatureDao userServiceFeatureDao,
                                                                               FeatureCallbackContextDao featureCallbackContextDao,
                                                                               TransactionTemplate transactionTemplate,
                                                                               BazingaTaskManager bazingaTaskManager,
                                                                               UserServiceDao userServiceDao,
                                                                               List<ErrorProcessor> errorProcessors) {
        return new UserFeaturesActualizationService(featureDao, productFeatureDao, externalSystemsRestTemplate,
                userServiceFeatureDao, featureCallbackContextDao, userServiceDao, tvm2, transactionTemplate,
                bazingaTaskManager, errorProcessors);
    }


    @Bean
    public GroupFeaturesActualizationService groupFeaturesActualizationService(FeatureDao featureDao, Tvm2 tvm2,
                                                                               ProductFeatureDao productFeatureDao,
                                                                               @FeaturesSynchronize RestTemplate externalSystemsRestTemplate,
                                                                               GroupServiceFeatureDao groupServiceFeatureDao,
                                                                               FeatureCallbackContextDao featureCallbackContextDao,
                                                                               TransactionTemplate transactionTemplate,
                                                                               BazingaTaskManager bazingaTaskManager,
                                                                               GroupServiceDao groupServiceDao,
                                                                               GroupTemplateContextFactory groupTemplateContextFactory,
                                                                               List<ErrorProcessor> errorProcessors) {
        return new GroupFeaturesActualizationService(featureDao, productFeatureDao, externalSystemsRestTemplate,
                groupServiceFeatureDao, featureCallbackContextDao, groupServiceDao, tvm2, transactionTemplate,
                bazingaTaskManager, groupTemplateContextFactory, errorProcessors);
    }

    @Bean
    @FeaturesSynchronize
    @OverridableValuePrefix("features-synchronization")
    public HttpClientConfigurator featuresSynchronizationHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @FeaturesSynchronize
    @Bean
    public RestTemplate featuresSynchronizeRestTemplate(
            @FeaturesSynchronize HttpClientConfigurator httpClientConfigurator
    ) {
        CloseableHttpClient httpClient = httpClientConfigurator.createBuilder()
                .multiThreaded()
                .build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "ext_system");
        return new RestTemplate(new HttpComponentsClientHttpRequestFactory(wrapped));
    }

}
