package ru.yandex.chemodan.app.psbilling.core.config;

import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.dao.texts.TankerKeyDao;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManagerCacheChecker;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.HttpClientWithThreadLocalVariable;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.inside.tanker.TankerClient;

@Configuration
@Import(PsBillingCoreDaoConfiguration.class)
public class PsBillingTankerConfiguration {

    @Bean
    public TankerClient tankerClient(HttpClientConfigurator tankerHttpClientConfigurator,
                                     @Value("${tanker.host}") String host) {
        CloseableHttpClient httpClient = tankerHttpClientConfigurator.createBuilder().multiThreaded().build();
        CloseableHttpClient wrapped = new HttpClientWithThreadLocalVariable(httpClient, "name", "tanker");
        return new TankerClient(wrapped, host);
    }

    @Bean
    public TextsManager textsManager(TankerClient tankerClient, TankerKeyDao tankerKeyDao) {
        return new TextsManager(tankerClient, tankerKeyDao);
    }

    @Bean
    @OverridableValuePrefix("tanker")
    public HttpClientConfigurator tankerHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public PingerChecker textsManagerCacheChecker(TextsManager textsManager) {
        return new TextsManagerCacheChecker(textsManager);
    }

}
