package ru.yandex.chemodan.app.psbilling.core.config;


import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.boot.ChemodanInitContextConfiguration;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.LoggingHttpInterceptor;
import ru.yandex.chemodan.trust.client.TrustClient;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvm2ContextConfiguration;
import ru.yandex.misc.lang.DefaultObject;

@Configuration
@Import({
        ZkTvm2ContextConfiguration.class,
        ChemodanInitContextConfiguration.class
})
public class PsBillingTrustConfiguration {
    @Bean
    public TrustClient trustClient(@Value("${trust.url}") String trustUrl,
            @Trust HttpClientConfigurator trustHttpClientConfigurator, List<TrustServiceDefinition> services)
    {
        LoggingHttpInterceptor httpInterceptor = new LoggingHttpInterceptor("trust", true);
        HttpClient httpClient = trustHttpClientConfigurator.createBuilder()
                .multiThreaded()
                .withInterceptorLast((HttpRequestInterceptor) httpInterceptor)
                .withInterceptorFirst((HttpResponseInterceptor) httpInterceptor)
                .build();
        return new TrustClient(httpClient, trustUrl,
                Cf.x(services).toMap(TrustServiceDefinition::getServiceId, TrustServiceDefinition::getServiceToken));
    }

    @Bean
    public TrustServiceDefinition mailService(
            @Value("${trust.services.mail.serviceId}") Integer mailServiceId,
            @Value("${trust.services.mail.serviceToken}") String mailToken
    )
    {
        return new TrustServiceDefinition(mailServiceId, mailToken);
    }

    @Bean
    public TrustServiceDefinition diskService(
            @Value("${trust.services.disk.serviceId}") Integer mailServiceId,
            @Value("${trust.services.disk.serviceToken}") String mailToken
    ) {
        return new TrustServiceDefinition(mailServiceId, mailToken);
    }

    @Bean
    public TrustServiceDefinition mailB2bService(
            @Value("${trust.services.mailb2b.serviceId}") Integer mailServiceId,
            @Value("${trust.services.mailb2b.serviceToken}") String mailToken
    ) {
        return new TrustServiceDefinition(mailServiceId, mailToken);
    }

    @Bean
    @OverridableValuePrefix("trust")
    @Trust
    public HttpClientConfigurator trustHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }


    @Qualifier
    @Retention(RetentionPolicy.RUNTIME)
    public @interface Trust {
    }

    @Getter
    @AllArgsConstructor
    public static class TrustServiceDefinition extends DefaultObject {
        private Integer serviceId;
        private String serviceToken;
    }
}
