package ru.yandex.chemodan.app.psbilling.core.config;

import java.util.function.Function;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.converter.ToPromoPayloadConverter;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.products.SpringExpressionEvaluator;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoPayloadParser;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.util.blackbox.UserTimezoneHelper;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({ProdBlackboxContextConfiguration.class, PsBillingTankerConfiguration.class})
public class PsBillingUtilsConfiguration {
    @Bean
    public SpringExpressionEvaluator springExpressionEvaluator(ApplicationContext applicationContext) {
        return new SpringExpressionEvaluator(applicationContext);
    }

    @Bean
    public UserTimezoneHelper userTimezoneHelper(Blackbox2 blackbox2) {
        return new UserTimezoneHelper(blackbox2);
    }

    @Bean
    public PromoPayloadParser promoPayloadParser(TextsManager textsManager) {
        return new PromoPayloadParser(textsManager);
    }

    @Bean
    public Function<ToPromoPayloadConverter.ConvertData, Option<String>> toPayload(
            PromoPayloadDao promoPayloadDao,
            PromoPayloadParser promoPayloadParser
    ) {
        return new ToPromoPayloadConverter(promoPayloadDao, promoPayloadParser);
    }
}
