package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.users.ProductsExportService;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.TrialDefinitionDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductLineDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductOwnerDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductSetDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductBucketDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPeriodDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductPricesDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.SpringExpressionEvaluator;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.products.selectors.ProductLineSelectorFactory;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsManager;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.directory.client.DirectoryClient;
import ru.yandex.chemodan.trust.client.TrustClient;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingDirectoryConfiguration.class,
        PsBillingTrustConfiguration.class,
        PsBillingUtilsConfiguration.class,
        PromoConfiguration.class,
        CommonServicesConfig.class
})

public class UserProductConfiguration {

    @Bean
    public ProductLineSelectorFactory productLineSelectorFactory(Blackbox2 blackbox2,
                                                                 TrialService trialService,
                                                                 DirectoryClient directoryClient,
                                                                 ExperimentsManager experimentsManager,
                                                                 GroupServiceDao groupServiceDao,
                                                                 GroupDao groupDao,
                                                                 FeatureFlags featureFlags,
                                                                 UserServiceManager userServiceManager,
                                                                 UserProductDao userProductDao) {
        return new ProductLineSelectorFactory(blackbox2, trialService, directoryClient, experimentsManager,
                groupServiceDao, groupDao, featureFlags, userServiceManager, userProductDao);
    }

    @Bean
    public UserProductManager userProductManager(ProductSetDao productSetDao, ProductLineDao productLineDao,
                                                 TextsManager textsManager, PromoService promoService,
                                                 ProductFeatureDao productFeatureDao,
                                                 UserProductDao userProductDao,
                                                 UserProductPricesDao userProductPricesDao,
                                                 UserProductPeriodDao userProductPeriodDao,
                                                 UserServiceDao userServiceDao, TrialDefinitionDao trialDefinitionDao,
                                                 SpringExpressionEvaluator springExpressionEvaluator,
                                                 ProductOwnerDao productOwnerDao,
                                                 UserProductBucketDao userProductBucketDao) {
        return new UserProductManager(productSetDao, productLineDao, userProductDao, userProductPricesDao,
                productFeatureDao, textsManager, promoService, userServiceDao, trialDefinitionDao,
                userProductPeriodDao, productOwnerDao, userProductBucketDao,
                springExpressionEvaluator);
    }

    @Bean
    public ProductsExportService productsExportService(TrustClient trustClient, UserProductManager userProductManager) {
        return new ProductsExportService(trustClient, userProductManager);
    }
}
