package ru.yandex.chemodan.app.psbilling.core.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.TrustDeveloperPayloadCreator;
import ru.yandex.chemodan.app.psbilling.core.billing.users.BillingActionsReportingService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.ReceiptHandlerV1;
import ru.yandex.chemodan.app.psbilling.core.billing.users.ReceiptHandlerV2;
import ru.yandex.chemodan.app.psbilling.core.billing.users.TrustRefundService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.InappSubscriptionProcessor;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.OrderProcessorFacade;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.PromocodeOrderProcessor;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.TrustSubscriptionProcessor;
import ru.yandex.chemodan.app.psbilling.core.config.featureflags.FeatureFlags;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.RefundDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.groups.TrialService;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationService;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserInfoService;
import ru.yandex.chemodan.app.psbilling.core.users.UserPassportSyncService;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.core.util.LockService;
import ru.yandex.chemodan.app.psbilling.core.yt.YtSelectService;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.mpfs.MpfsClient;
import ru.yandex.chemodan.mpfs.MpfsClientContextConfiguration;
import ru.yandex.chemodan.trust.client.TrustClient;
import ru.yandex.commune.bazinga.BazingaTaskManager;

@Configuration
@Import({
        PsBillingCoreDaoConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingSynchronizersConfiguration.class,
        MpfsClientContextConfiguration.class,
        PsBillingTrustConfiguration.class,
        CommonServicesConfig.class,
        UserProductConfiguration.class,
        YtConfiguration.class
})
public class UserServicesConfiguration {

    @Bean
    public ReceiptHandlerV1 receiptHandlerV1(OrderProcessorFacade orderProcessorFacade,
                                             MpfsClient mpfsClient) {
        return new ReceiptHandlerV1(orderProcessorFacade, mpfsClient);
    }

    @Bean
    public ReceiptHandlerV2 receiptHandlerV2(UserServiceManager userServiceManager,
                                             UserProductManager userProductManager,
                                             OrderProcessorFacade orderProcessorFacade,
                                             MpfsClient mpfsClient, FeatureFlags featureFlags,
                                             @Value("${ps-billing.receipt_check.max_pool_size}") int receiptCheckerMaxPoolSize,
                                             TrialService trialService) {
        return new ReceiptHandlerV2(userServiceManager, userProductManager, orderProcessorFacade, mpfsClient,
                featureFlags, receiptCheckerMaxPoolSize, trialService);
    }

    @Bean
    public TrustDeveloperPayloadCreator trustDeveloperPayload(TextsManager textsManager) {
        return new TrustDeveloperPayloadCreator(textsManager);
    }

    @Bean
    public UserBillingService userBillingService(
            TrustClient trustClient,
            UserInfoService userInfoService,
            UserProductManager userProductManager,
            UserServiceManager userServiceManager,
            MpfsClient mpfsClient,
            TrustRefundService trustRefundService,
            OrderProcessorFacade orderProcessorFacade,
            Settings settings,
            @Value("${trust.notification.url_template}") String notificationUrlTemplate,
            FeatureFlags featureFlags,
            TrustDeveloperPayloadCreator trustDeveloperPayloadCreator
    ) {
        return new UserBillingService(
                trustClient,
                userInfoService,
                notificationUrlTemplate,
                trustRefundService,
                orderProcessorFacade,
                userServiceManager,
                userProductManager,
                mpfsClient,
                settings,
                featureFlags,
                trustDeveloperPayloadCreator
        );
    }

    @Bean
    public TrustRefundService trustRefundService(TrustClient trustClient, UserServiceManager userServiceManager,
                                                 OrderDao orderDao, RefundDao refundDao, LockService lockService,
                                                 UserProductManager userProductManager,
                                                 BazingaTaskManager bazingaTaskManager, FeatureFlags featureFlags,
                                                 BillingActionsReportingService billingActionsReportingService) {
        return new TrustRefundService(trustClient, orderDao, refundDao, userServiceManager, lockService,
                userProductManager, bazingaTaskManager, featureFlags, billingActionsReportingService);
    }

    @Bean
    public BillingActionsReportingService billingActionsReportingService() {
        return new BillingActionsReportingService();
    }

    @Bean
    public OrderProcessorFacade orderProcessorFacade(BazingaTaskManager bazingaTaskManager, OrderDao orderDao,
                                                     TrustSubscriptionProcessor trustSubscriptionProcessor,
                                                     InappSubscriptionProcessor inappSubscriptionProcessor,
                                                     PromocodeOrderProcessor promocodeOrderProcessor) {
        return new OrderProcessorFacade(bazingaTaskManager, orderDao, trustSubscriptionProcessor,
                inappSubscriptionProcessor, promocodeOrderProcessor);
    }

    @Bean
    public InappSubscriptionProcessor inappSubscriptionProcessor(BazingaTaskManager bazingaTaskManager,
                                                                 OrderDao orderDao, Settings settings,
                                                                 UserProductManager userProductManager,
                                                                 TrustClient trustClient,
                                                                 UserServiceManager userServiceManager,
                                                                 LockService lockService, TaskScheduler taskScheduler,
                                                                 UserServiceDao userServiceDao,
                                                                 PromoService promoService,
                                                                 FeatureFlags featureFlags,
                                                                 @Value("${trust.inapp.serviceId}") Integer inappTrustServiceId,
                                                                 BillingActionsReportingService billingActionsReportingService) {
        return new InappSubscriptionProcessor(bazingaTaskManager, trustClient, orderDao, userServiceManager,
                lockService, userProductManager, inappTrustServiceId, taskScheduler, userServiceDao, promoService,
                settings, featureFlags, billingActionsReportingService);
    }

    @Bean
    public PromocodeOrderProcessor promocodeOrderProcessor(BazingaTaskManager bazingaTaskManager,
                                                           OrderDao orderDao, Settings settings,
                                                           UserProductManager userProductManager,
                                                           UserServiceManager userServiceManager,
                                                           LockService lockService,
                                                           TaskScheduler taskScheduler,
                                                           UserServiceDao userServiceDao,
                                                           PromoService promoService, FeatureFlags featureFlags,
                                                           BillingActionsReportingService billingActionsReportingService) {
        return new PromocodeOrderProcessor(bazingaTaskManager, orderDao, userServiceManager, lockService,
                userProductManager, taskScheduler, userServiceDao, promoService, settings, featureFlags,
                billingActionsReportingService);
    }

    @Bean
    public TrustSubscriptionProcessor trustSubscriptionProcessor(BazingaTaskManager bazingaTaskManager,
                                                                 OrderDao orderDao, Settings settings,
                                                                 UserProductManager userProductManager,
                                                                 TrustClient trustClient,
                                                                 UserServiceManager userServiceManager,
                                                                 LockService lockService,
                                                                 TaskScheduler taskScheduler,
                                                                 UserServiceDao userServiceDao,
                                                                 PromoService promoService,
                                                                 FeatureFlags featureFlags,
                                                                 BillingActionsReportingService billingActionsReportingService, TrustRefundService trustRefundService) {
        return new TrustSubscriptionProcessor(bazingaTaskManager, trustClient, orderDao, userServiceManager,
                lockService, userProductManager, taskScheduler, userServiceDao, promoService, settings, featureFlags,
                billingActionsReportingService, trustRefundService);
    }

    @Bean
    public UserServiceManager userServiceManager(UserServiceDao userServiceDao, UserProductManager userProductManager,
                                                 UserServiceActualizationService userServiceActualizationService,
                                                 TrialService trialService, OrderDao orderDao,
                                                 LockService lockService, TrustClient trustClient,
                                                 TaskScheduler taskScheduler,
                                                 BillingActionsReportingService billingActionsReportingService) {
        return new UserServiceManager(userServiceDao, userServiceActualizationService, trustClient,
                userProductManager, orderDao, lockService, trialService,
                taskScheduler, billingActionsReportingService);
    }

    @Bean
    public UserPassportSyncService userPassportSyncService(YtSelectService ytSelectService,
                                                           UserServiceDao userServiceDao,
                                                           TaskScheduler taskScheduler) {
        return new UserPassportSyncService(ytSelectService, userServiceDao, taskScheduler);
    }
}
