package ru.yandex.chemodan.app.psbilling.core.config;

import java.util.concurrent.TimeUnit;

import net.jodah.failsafe.RetryPolicy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.yt.YtCluster;
import ru.yandex.chemodan.app.psbilling.core.yt.YtSelectService;
import ru.yandex.chemodan.util.yt.YtHelper;
import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

@Configuration
public class YtConfiguration {
    @Bean
    public YtExportSettings groupServicesPrimaryExportSettings(
            @Value("${billing.yt.group_services.primary.enabled}") boolean enabled,
            @Value("${billing.yt.group_services.primary.export.path}") String path,
            @Value("${billing.yt.group_services.primary.url}") String ytUrl,
            @Value("${billing.yt.auth_token}") String ytToken) {
        Yt yt = YtUtils.http(ytUrl, ytToken);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(3).withDelay(10, TimeUnit.SECONDS);
        return new YtExportSettings(enabled, YPath.simple(path), new YtHelper(yt, retryPolicy));
    }

    @Bean
    public YtExportSettings groupServicesSecondaryExportSettings(
            @Value("${billing.yt.group_services.secondary.enabled}") boolean enabled,
            @Value("${billing.yt.group_services.secondary.export.path}") String path,
            @Value("${billing.yt.group_services.secondary.url}") String ytUrl,
            @Value("${billing.yt.auth_token}") String ytToken) {
        Yt yt = YtUtils.http(ytUrl, ytToken);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(3).withDelay(10, TimeUnit.SECONDS);

        return new YtExportSettings(enabled, YPath.simple(path), new YtHelper(yt, retryPolicy));
    }

    @Bean
    public YtExportSettings distributionPlatformPrimaryExportSettings(
            @Value("${billing.yt.distribution_platform.primary.enabled}") boolean enabled,
            @Value("${billing.yt.distribution_platform.primary.export.path}") String path,
            @Value("${billing.yt.distribution_platform.primary.url}") String ytUrl,
            @Value("${billing.yt.auth_token}") String ytToken) {
        Yt yt = YtUtils.http(ytUrl, ytToken);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(3).withDelay(10, TimeUnit.SECONDS);
        return new YtExportSettings(enabled, YPath.simple(path), new YtHelper(yt, retryPolicy));
    }

    @Bean
    public YtExportSettings distributionPlatformSecondaryExportSettings(
            @Value("${billing.yt.distribution_platform.secondary.enabled}") boolean enabled,
            @Value("${billing.yt.distribution_platform.secondary.export.path}") String path,
            @Value("${billing.yt.distribution_platform.secondary.url}") String ytUrl,
            @Value("${billing.yt.auth_token}") String ytToken) {
        Yt yt = YtUtils.http(ytUrl, ytToken);
        RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(3).withDelay(10, TimeUnit.SECONDS);

        return new YtExportSettings(enabled, YPath.simple(path), new YtHelper(yt, retryPolicy));
    }

    @Bean
    public YtSelectService ytSelectService(
            @Value("${yt.select.token}") String ytToken,
            @Value("${yt.select.urls.hahn}") String ytHahnUrl
    ) {
        return new YtSelectService(
                Cf.map(YtCluster.HAHN, ytHahnUrl),
                ytToken
        );
    }
}
