package ru.yandex.chemodan.app.psbilling.core.config.featureflags;

import java.util.regex.Pattern;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;

public abstract class AbstractFeature {
    private static final String valueRegex = " *true *| *false *| *\\d+( *, *\\d*)* *";
    protected String value;

    protected String getValue() {
        return value;
    }

    public void setValue(String value) {
        if (!validateValue(value)) {
            throw new IllegalStateException(String.format("value '%s' does not match regexp '%s'", value, valueRegex));
        }
        this.value = value;
    }

    public boolean isEnabledForUid(PassportUid uid) {
        return isStrictEnabled() || getUidsToRefundUpgrades().containsTs(uid);
    }

    public boolean isEnabled() {
        return isStrictEnabled();
    }

    public static boolean validateValue(String value) {
        return Pattern.matches(valueRegex, value.toLowerCase());
    }

    private SetF<PassportUid> getUidsToRefundUpgrades() {
        if (!Pattern.matches(" *\\d+( *, *\\d*)* *", getValue().toLowerCase())) {
            return Cf.set();
        }

        return Cf.toSet(Cf.list(StringUtils.split(getValue(), ","))
                .map(String::trim)
                .map(Long::parseLong)
                .map(PassportUid::cons));
    }

    private boolean isStrictEnabled() {
        return Boolean.parseBoolean(getValue().trim());
    }

}
