package ru.yandex.chemodan.app.psbilling.core.config.featureflags;

import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/*
фиче флаги. Когда надо выкатить потенциально опасную или непротестированную логику в прод, закрываем ее под фичефлагом
например
if (!featureFlags.getExample().isEnabledForUid(passportUid)) {
    return;
}
if (!featureFlags.getExample().isEnabled()) {
    return;
}
 */
@Getter
@SuppressWarnings("unused")
public class FeatureFlags {
//    private final DynamicProperty<String> exampleDp = createFeatureFlagOption(
//            "example");
//
//    private final DynamicFeature example = new DynamicFeature(exampleDp);

    private final DynamicProperty<String> pleaseComeBackPromoDp = createFeatureFlagOption(
            "please_come_back_promo_on_tuning");

    private final DynamicProperty<String> prepaidProductsDp = createFeatureFlagOption(
            "prepaid_products");

    private final DynamicProperty<String> useLastActDateFromGetPartnerBalanceDp = createFeatureFlagOption(
            "use_last_act_date_from_get_partner_balance");
    private final DynamicProperty<String> checkActDateDp = createFeatureFlagOption(
            "check_act_date");
    private final DynamicProperty<String> checkAvailableGroupProductDp = createFeatureFlagOption(
            "check_available_group_product"
    );
    private final DynamicProperty<String> checkTrustOrderIdDp = createFeatureFlagOption(
            "check_trust_order_id"
    );
    private final DynamicProperty<String> autoPayEnabledDp = createFeatureFlagOption("auto_pay_enabled");
    private final DynamicProperty<String> autoResurrectionPayAutoOnDp = createFeatureFlagOption(
            "auto_resurrection_pay_auto_on"
    );
    private final DynamicProperty<String> autoPayDisableOnUserIsNotAdminDp = createFeatureFlagOption(
            "auto_pay_disable_on_user_is_not_admin"
    );
    private final DynamicProperty<String> emailWelcomePaid360Dp = createFeatureFlagOption(
            "email_welcome_paid_360"
    );
    private final DynamicProperty<String> emailPaymentReminderDp = createFeatureFlagOption(
            "email_payment_reminder"
    );
    private final DynamicProperty<String> emailBalanceExhaustedDp = createFeatureFlagOption(
            "email_balance_exhausted"
    );
    private final DynamicProperty<String> emailsLanguageMappingsDp = createFeatureFlagOption(
            "emails_language_mappings"
    );

    private final DynamicProperty<String> inappStateChangesEmailDp = createFeatureFlagOption(
            "inapp_state_changes_email"
    );
    private final DynamicProperty<String> subscriptionOrderUseCreateIfNotExistsDp = createFeatureFlagOption(
            "subscription_order_use_create_if_not_exists"
    );
    private final DynamicProperty<String> inappMigrationAllowedDp = createFeatureFlagOption(
            "inapp_migration_allowed"
    );
    private final DynamicProperty<String> longBillingPeriodForTrustEmailEnabledDp = createFeatureFlagOption(
            "long_billing_period_for_trust_email_enabled"
    );
    private final DynamicProperty<String> b2bWelcomeEmailEnabledDp = createFeatureFlagOption(
            "b2b_welcome_email_enabled"
    );
    private final DynamicProperty<String> b2bPleaseComeBackEmailEnabledDp = createFeatureFlagOption(
            "b2b_please_come_back_email_enabled"
    );
    private final DynamicProperty<String> b2bAdminAbandonedPaymentEmailEnabledDp = createFeatureFlagOption(
            "b2b_admin_abandoned_payment_email_enabled"
    );

    private final DynamicProperty<String> preventInappBuyIfTrustExistsDp = createFeatureFlagOption(
            "prevent_inapp_buy_if_trust_exists"
    );

    private final DynamicProperty<String> allowUserGetBoughtInappProductDP = createFeatureFlagOption(
            "allow_user_get_bought_inapp_product"
    );

    private final DynamicProperty<String> hotFixGroupValidation = createFeatureFlagOption(
            "hot_fix_group_validation"
    );

    private final DynamicProperty<String> b2bUpsaleEmailEnabledDp = createFeatureFlagOption(
            "b2b_upsale_email_enabled_dp"
    );

    private final DynamicProperty<String> b2bBalanceExhaustedLatelyEmailEnabledDp = createFeatureFlagOption(
            "b2b_balance_exhausted_lately_email_enabled_dp"
    );

    private final DynamicProperty<String> disableStaleWebServicesDp = createFeatureFlagOption(
            "disable_stale_web_services_dp");

    private final DynamicProperty<String> newGroupSyncEnabledDp = createFeatureFlagOption(
            "new_group_sync_dp");

    //https://st.yandex-team.ru/CHEMODAN-78939
    private final DynamicFeature pleaseComeBackPromoOnTuning = new DynamicFeature(pleaseComeBackPromoDp);
    private final DynamicFeature prepaidProducts = new DynamicFeature(prepaidProductsDp);
    private final DynamicFeature checkAvailableGroupProduct = new DynamicFeature(checkAvailableGroupProductDp);
    //https://st.yandex-team.ru/CHEMODAN-82211
    private final DynamicFeature checkTrustOrderId = new DynamicFeature(checkTrustOrderIdDp);
    private final DynamicFeature autoResurrectionPayAutoOn = new DynamicFeature(autoResurrectionPayAutoOnDp);
    private final DynamicFeature autoPayDisableOnUserIsNotAdmin = new DynamicFeature(autoPayDisableOnUserIsNotAdminDp);
    private final DynamicFeature inappStateChangesEmail = new DynamicFeature(inappStateChangesEmailDp);
    private final DynamicFeature inappMigrationAllowed = new DynamicFeature(inappMigrationAllowedDp);
    //https://st.yandex-team.ru/CHEMODAN-83409
    private final DynamicFeature preventInappBuyIfTrustExists = new DynamicFeature(preventInappBuyIfTrustExistsDp);
    private final DynamicFeature allowUserGetBoughtInappProduct = new DynamicFeature(allowUserGetBoughtInappProductDP);
    private final DynamicFeature b2bWelcomeEmailEnabled = new DynamicFeature(b2bWelcomeEmailEnabledDp);
    private final DynamicFeature b2bPleaseComeBackEmailEnabled = new DynamicFeature(b2bPleaseComeBackEmailEnabledDp);
    private final DynamicFeature b2bAdminAbandonedPaymentEmailEnabled =
            new DynamicFeature(b2bAdminAbandonedPaymentEmailEnabledDp);
    private final DynamicFeature longBillingPeriodForTrustEmailEnabled =
            new DynamicFeature(longBillingPeriodForTrustEmailEnabledDp);
    private final DynamicFeature hotFixGroupValidationEnabled =
            new DynamicFeature(hotFixGroupValidation);
    private final DynamicFeature b2bUpsaleEmailEnabled = new DynamicFeature(b2bUpsaleEmailEnabledDp);
    private final DynamicFeature b2bBalanceExhaustedLatelyEmailEnabled =
            new DynamicFeature(b2bBalanceExhaustedLatelyEmailEnabledDp);
    private final DynamicFeature newGroupSyncEnabled = new DynamicFeature(newGroupSyncEnabledDp);
    /**
     * Используется при создании Order в ручке /v1/users/subscribe
     * CHEMODAN-82785 - Удалить флаг как только обкатаем функционал.
     */
    private final DynamicFeature subscriptionOrderUseCreateIfNotExists =
            new DynamicFeature(subscriptionOrderUseCreateIfNotExistsDp);

    //CHEMODAN-84596
    private final DynamicFeature disableStaleWebServices =
            new DynamicFeature(disableStaleWebServicesDp);

    private final DynamicProperty<BalanceInactiveContractFeature> balanceWithInactiveContract = new DynamicProperty<>(
            "ps-billing.feature_flags.balance_with_finished_contract",
            new BalanceInactiveContractFeature(false, Cf.list()));

    private DynamicProperty<String> createFeatureFlagOption(String featureName) {
        return new DynamicProperty<>("ps-billing.feature_flags." + featureName, "false",
                AbstractFeature::validateValue);
    }


    @Bendable
    public static class BalanceInactiveContractFeature extends DefaultObject {
        @BenderPart
        private final boolean force;
        @BenderPart
        private final ListF<Long> clientIds;

        private BalanceInactiveContractFeature(boolean force, ListF<Long> clientIds) {
            this.force = force;
            this.clientIds = clientIds;
        }

        public boolean isEnableByClientId(Long clientId) {
            return force || clientIds.containsTs(clientId);
        }
    }
}

