package ru.yandex.chemodan.app.psbilling.core.config.tasks;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.GroupFeatureActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.feature.UserFeatureActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember.GroupServiceMemberActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupmember.GroupServiceMemberActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservice.GroupServicesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.groupservicefeature.GroupFeaturesActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservice.UserServiceActualizationTask;
import ru.yandex.chemodan.app.psbilling.core.synchronization.userservicefeature.UserFeaturesActualizationService;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class ActualizationTasksConfiguration {
    @Bean
    public GroupActualizationTask groupActualizationTask(
            GroupServicesActualizationService groupServicesActualizationService) {
        return new GroupActualizationTask(groupServicesActualizationService);
    }

    @Bean
    public GroupServiceMemberActualizationTask groupServiceMemberActualizationTask(
            GroupServiceMemberActualizationService groupServiceMemberActualizationService
    ) {
        return new GroupServiceMemberActualizationTask(groupServiceMemberActualizationService);
    }

    @Bean
    public UserServiceActualizationTask userServiceActualizationTask(
            UserServiceActualizationService userServiceActualizationService) {
        return new UserServiceActualizationTask(userServiceActualizationService);
    }

    @Bean
    public UserFeatureActualizationTask userFeatureActualizationTask(
            UserFeaturesActualizationService userFeaturesActualizationService
    ) {
        return new UserFeatureActualizationTask(userFeaturesActualizationService);
    }

    @Bean
    public GroupFeatureActualizationTask groupFeatureActualizationTask(
            GroupFeaturesActualizationService groupFeaturesActualizationService
    ) {
        return new GroupFeatureActualizationTask(groupFeaturesActualizationService);
    }
}
