package ru.yandex.chemodan.app.psbilling.core.config.tasks;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.AutoResurrectionPayManager;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.CheckGroupBillingStatusTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.CheckPaymentRequestStatusTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.ClientBalanceCalculator;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.DistributionPlatformCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.DistributionPlatformCalculationTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.GroupServiceTransactionsCalculationTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.ManualRecalculationTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportService;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.groupservices.GroupServiceTransactionsExportTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.CardBindingChecker;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.payment.PaymentChecker;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks.CheckCardBindingStatusTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks.GroupAutoBillingTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks.GroupAutoReBillingTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks.UpdateClientBalanceTask;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.tasks.UpdateClientTransactionsBalanceTask;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupServiceTransactionsDao;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.psbilling.core.users.tasks.DeleteUserTask;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class GroupBillingTasksConfiguration {

    @Bean
    public DistributionPlatformCalculationTask distributionPlatformCalculationTask(
            DistributionPlatformCalculationService distributionPlatformCalculationService) {
        return new DistributionPlatformCalculationTask(distributionPlatformCalculationService);
    }

    @Bean
    public GroupServiceTransactionsCalculationTask groupTransactionCalculationTask(
            GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService) {
        return new GroupServiceTransactionsCalculationTask(groupServiceTransactionsCalculationService);
    }

    @Bean
    public GroupServiceTransactionsExportTask groupServiceTransactionsExportTask(
            GroupServiceTransactionsExportService groupServiceTransactionsExportService) {
        return new GroupServiceTransactionsExportTask(groupServiceTransactionsExportService);
    }

    @Bean
    public CheckGroupBillingStatusTask checkGroupBillingStatusTask(GroupBillingService groupBillingService) {
        return new CheckGroupBillingStatusTask(groupBillingService);
    }

    @Bean
    public ManualRecalculationTask manualRecalculationTask(GroupServiceTransactionsCalculationService groupServiceTransactionsCalculationService) {
        return new ManualRecalculationTask(groupServiceTransactionsCalculationService);
    }

    @Bean
    public CheckPaymentRequestStatusTask checkPaymentRequestStatusTask(PaymentChecker paymentChecker) {
        return new CheckPaymentRequestStatusTask(paymentChecker);
    }

    @Bean
    public CheckCardBindingStatusTask checkCardBindingStatusTask(CardBindingChecker cardBindingChecker) {
        return new CheckCardBindingStatusTask(cardBindingChecker);
    }

    @Bean
    public UpdateClientTransactionsBalanceTask updateClientTransactionsBalanceTask(GroupServiceTransactionsDao groupServiceTransactionsDao,
                                                                                   TaskScheduler taskScheduler) {
        return new UpdateClientTransactionsBalanceTask(groupServiceTransactionsDao, taskScheduler);
    }

    @Bean
    public UpdateClientBalanceTask updateClientBalanceTask(ClientBalanceCalculator clientBalanceCalculator) {
        return new UpdateClientBalanceTask(clientBalanceCalculator);
    }

    @Bean
    public DeleteUserTask deleteUserTask(UserServiceManager userServiceManager) {
        return new DeleteUserTask(userServiceManager);
    }

    @Bean
    public GroupAutoBillingTask groupAutoBillingTask(AutoPayManager autoPayManager) {
        return new GroupAutoBillingTask(autoPayManager);
    }

    @Bean
    public GroupAutoReBillingTask groupAutoReBillingTask(AutoResurrectionPayManager autoResurrectionPayManager) {
        return new GroupAutoReBillingTask(autoResurrectionPayManager);
    }
}
