package ru.yandex.chemodan.app.psbilling.core.config.tasks;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.balance.BalanceService;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupTrustPaymentRequestDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.groups.GroupServicesManager;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.B2BAdminAbandonedPaymentTask;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.B2BTariffAcquisitionEmailTask;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.EmailPaymentsAwareMembersTask;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.SendLocalizedEmailTask;
import ru.yandex.chemodan.app.psbilling.core.mail.tasks.SendTransactionalEmailWithInvoiceCreationTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({
        TasksExecutionConfiguration.class
})
public class MailTasksConfiguration {
    @Bean
    public SendTransactionalEmailWithInvoiceCreationTask sendTransactionalEmailWithInvoiceCreationTask(
            TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
            List<TaskExecutor<?>> taskExecutors) {
        return new SendTransactionalEmailWithInvoiceCreationTask(taskPreExecutionPoliciesHolder,
                Cf.toList(taskExecutors));
    }

    @Bean
    public SendLocalizedEmailTask sendLocalizedEmailTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                                         List<TaskExecutor<?>> taskExecutors) {
        return new SendLocalizedEmailTask(taskPreExecutionPoliciesHolder, Cf.toList(taskExecutors));
    }

    @Bean
    public EmailPaymentsAwareMembersTask emailPaymentsAwareMembersTask(
            TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder, List<TaskExecutor<?>> taskExecutors,
            GroupDao groupDao, TaskScheduler taskScheduler, BalanceService balanceService, Blackbox2 blackbox2) {
        return new EmailPaymentsAwareMembersTask(taskPreExecutionPoliciesHolder, Cf.toList(taskExecutors),
                groupDao, taskScheduler, balanceService, blackbox2);
    }

    @Bean
    public B2BAdminAbandonedPaymentTask b2BAdminAbandonedPaymentTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                                                     List<TaskExecutor<?>> taskExecutors,
                                                                     TaskScheduler taskScheduler,
                                                                     GroupTrustPaymentRequestDao groupTrustPaymentRequestDao,
                                                                     GroupServicesManager groupServicesManager,
                                                                     GroupProductDao groupProductDao) {
        return new B2BAdminAbandonedPaymentTask(taskPreExecutionPoliciesHolder, Cf.toList(taskExecutors),
                taskScheduler, groupTrustPaymentRequestDao, groupServicesManager, groupProductDao);
    }

    @Bean
    public B2BTariffAcquisitionEmailTask b2BTariffAcquisitionEmailTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                                                       List<TaskExecutor<?>> taskExecutors,
                                                                       SentEmailInfoDao sentEmailInfoDao) {
        return new B2BTariffAcquisitionEmailTask(taskPreExecutionPoliciesHolder, Cf.toList(taskExecutors),
                sentEmailInfoDao);
    }
}
