package ru.yandex.chemodan.app.psbilling.core.config.tasks;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.promocodes.PromoCodeService;
import ru.yandex.chemodan.app.psbilling.core.promocodes.tasks.GeneratePromoCodeTask;
import ru.yandex.chemodan.app.psbilling.core.promos.tasks.ActivatePromoTask;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class PromoTasksConfiguration {
    @Bean
    public ActivatePromoTask activatePromoTask(TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder,
                                               List<TaskExecutor<?>> taskExecutors) {
        return new ActivatePromoTask(taskPreExecutionPoliciesHolder, Cf.toList(taskExecutors));
    }

    @Bean
    public GeneratePromoCodeTask generatePromoCodeTask(PromoCodeService promoCodeService){
        return new GeneratePromoCodeTask(promoCodeService);
    }
}
