package ru.yandex.chemodan.app.psbilling.core.config.tasks;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.config.MailSendingConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.MailSendingDataConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingBazingaClientConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingTankerConfiguration;
import ru.yandex.chemodan.app.psbilling.core.config.UserServicesConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.EmailTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.UserPromoDao;
import ru.yandex.chemodan.app.psbilling.core.dao.texts.TankerKeyDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserServiceDao;
import ru.yandex.chemodan.app.psbilling.core.mail.SenderClient;
import ru.yandex.chemodan.app.psbilling.core.mail.configuration.GlobalMailConfiguration;
import ru.yandex.chemodan.app.psbilling.core.mail.dataproviders.LocalizedEmailSenderDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.CardNameKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.DiskSpaceKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.DomainsKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.EmailKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.FanMailLimitKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.InappStoreNameKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.MailArchiveTextKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.PaymentDeadlineKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.PriceDataKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.PromoFieldsKeyProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.SubscriptionInfoKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.TariffNameKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.UidKeyDataProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.UserPromoKeyProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.keydataproviders.UserPublicNameKeyProvider;
import ru.yandex.chemodan.app.psbilling.core.mail.localization.DateResolver;
import ru.yandex.chemodan.app.psbilling.core.products.ProductLineService;
import ru.yandex.chemodan.app.psbilling.core.products.UserProductManager;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoService;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.mail.LocalizedEmailTaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.promo.ActivatePromoTaskTaskExecutor;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.PoliciesInfoProvider;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPoliciesHolder;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.TaskPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail.EmailNeverSentBeforeTaskPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail.OnlyFreeUsersEmailTaskPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.mail.RegularEmailTaskPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.tasks.policies.promo.PromoActivationPreExecutionPolicy;
import ru.yandex.chemodan.app.psbilling.core.texts.TextsManager;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;
import ru.yandex.chemodan.app.uaas.experiments.ExperimentsContextConfigutation;
import ru.yandex.chemodan.blackbox.ProdBlackboxContextConfiguration;
import ru.yandex.chemodan.domenator.DomenatorClient;
import ru.yandex.chemodan.domenator.DomenatorClientContextConfiguration;
import ru.yandex.inside.passport.blackbox2.Blackbox2;

@Configuration
@Import({
        PsBillingBazingaClientConfiguration.class,
        ProdBlackboxContextConfiguration.class,
        PsBillingTankerConfiguration.class,
        ExperimentsContextConfigutation.class,
        MailSendingConfiguration.class,
        MailSendingDataConfiguration.class,
        UserServicesConfiguration.class,
        DomenatorClientContextConfiguration.class
})
public class TasksExecutionConfiguration {
    @Bean
    public UserPublicNameKeyProvider emailKeyDataProvider(Blackbox2 blackbox2) {
        return new UserPublicNameKeyProvider(blackbox2);
    }

    @Bean
    public PromoFieldsKeyProvider promoNameKeyProvider(PromoTemplateDao promoTemplateDao,
                                                       TextsManager textsManager, DateResolver dateResolver) {
        return new PromoFieldsKeyProvider(promoTemplateDao, textsManager, dateResolver);
    }

    @Bean
    public SubscriptionInfoKeyDataProvider subscriptionInfoKeyDataProvider(
            UserServiceManager userServiceManager, DateResolver dateResolver) {
        return new SubscriptionInfoKeyDataProvider(dateResolver, userServiceManager);
    }

    @Bean
    public UserPromoKeyProvider promoKeyProvider(DateResolver dateResolver, UserPromoDao userPromoDao) {
        return new UserPromoKeyProvider(dateResolver, userPromoDao);
    }

    @Bean
    public TariffNameKeyDataProvider tariffNameKeyDataProvider(
            UserServiceManager userServiceManager, UserProductManager userProductManager,
            GroupProductDao groupProductDao, TankerKeyDao tankerKeyDao) {
        return new TariffNameKeyDataProvider(userServiceManager, userProductManager, groupProductDao, tankerKeyDao);
    }

    @Bean
    public CardNameKeyDataProvider cardNameKeyDataProvider() {
        return new CardNameKeyDataProvider();
    }

    @Bean
    public InappStoreNameKeyDataProvider inappStoreNameKeyDataProvider() {
        return new InappStoreNameKeyDataProvider();
    }

    @Bean
    public PriceDataKeyDataProvider priceDataKeyDataProvider(
            UserProductManager userProductManager, TextsManager textsManager, UserBillingService userBillingService) {
        return new PriceDataKeyDataProvider(userProductManager, textsManager, userBillingService);
    }

    @Bean
    public DomainsKeyDataProvider domainsKeyDataProvider(DomenatorClient domenatorClient) {
        return new DomainsKeyDataProvider(domenatorClient);
    }

    @Bean
    public DiskSpaceKeyDataProvider diskSpaceKeyDataProvider(
            UserProductManager userProductManager, UserProductDao userProductDao) {
        return new DiskSpaceKeyDataProvider(userProductManager, userProductDao);
    }

    @Bean
    public FanMailLimitKeyDataProvider featuresKeyDataProvider(
            UserProductManager userProductManager, UserProductDao userProductDao) {
        return new FanMailLimitKeyDataProvider(userProductManager, userProductDao);
    }

    @Bean
    public MailArchiveTextKeyDataProvider mailArchiveTextKeyDataProvider(
            UserProductDao userProductDao, UserProductManager userProductManager, TextsManager textsManager) {
        return new MailArchiveTextKeyDataProvider(userProductDao, userProductManager, textsManager);
    }

    @Bean
    public PaymentDeadlineKeyDataProvider paymentDeadlineKeyDataProvider(DateResolver dateResolver) {
        return new PaymentDeadlineKeyDataProvider(dateResolver);
    }

    @Bean
    public UidKeyDataProvider uidKeyDataProvider() {
        return new UidKeyDataProvider();
    }

    @Bean
    public LocalizedEmailSenderDataProvider localizedEmailSenderDataProvider(
            EmailTemplateDao emailTemplateDao,
            List<EmailKeyDataProvider> emailKeyDataProviders,
            Blackbox2 blackbox2) {
        return new LocalizedEmailSenderDataProvider(
                emailTemplateDao, Cf.x(emailKeyDataProviders), blackbox2);
    }

    @Bean
    public TaskPreExecutionPoliciesHolder taskPreExecutionPoliciesHolder(List<TaskPreExecutionPolicy<?>> emailTaskProcessStrategies) {
        return new TaskPreExecutionPoliciesHolder(Cf.toList(emailTaskProcessStrategies));
    }

    @Bean
    public PoliciesInfoProvider policiesInfoProvider(UserServiceDao userServiceDao,
                                                     OrderDao orderDao) {
        return new PoliciesInfoProvider(userServiceDao, orderDao);
    }

    @Bean
    public OnlyFreeUsersEmailTaskPreExecutionPolicy onlyFreeUsersEmailTaskPreExecutionPolicy(EmailTemplateDao emailTemplateDao,
                                                                                             GlobalMailConfiguration globalMailConfiguration,
                                                                                             PoliciesInfoProvider policiesInfoProvider,
                                                                                             SentEmailInfoDao sentEmailInfoDao) {
        return new OnlyFreeUsersEmailTaskPreExecutionPolicy(emailTemplateDao, globalMailConfiguration,
                policiesInfoProvider, sentEmailInfoDao);
    }

    @Bean
    public EmailNeverSentBeforeTaskPreExecutionPolicy emailNeverSentBeforeTaskPreExecutionPolicy(
            EmailTemplateDao emailTemplateDao,
            GlobalMailConfiguration globalMailConfiguration,
            SentEmailInfoDao sentEmailInfoDao
    ) {
        return new EmailNeverSentBeforeTaskPreExecutionPolicy(emailTemplateDao, globalMailConfiguration,
                sentEmailInfoDao);
    }


    @Bean
    public PromoActivationPreExecutionPolicy promoActivationPreExecutionPolicy(
            PoliciesInfoProvider policiesInfoProvider,
            PromoService promoService,
            ProductLineService productLineService) {
        return new PromoActivationPreExecutionPolicy(promoService, policiesInfoProvider, productLineService);
    }

    @Bean
    public LocalizedEmailTaskExecutor localizedEmailTaskExecutor(SenderClient senderClient,
                                                                 EmailTemplateDao emailTemplateDao,
                                                                 LocalizedEmailSenderDataProvider localizedEmailSenderDataProvider,
                                                                 SentEmailInfoDao sentEmailInfoDao) {
        return new LocalizedEmailTaskExecutor(senderClient, localizedEmailSenderDataProvider, sentEmailInfoDao,
                emailTemplateDao);
    }

    @Bean
    public RegularEmailTaskPreExecutionPolicy regularEmailTaskPreExecutionPolicy(EmailTemplateDao emailTemplateDao,
                                                                                 GlobalMailConfiguration globalMailConfiguration,
                                                                                 SentEmailInfoDao sentEmailInfoDao) {
        return new RegularEmailTaskPreExecutionPolicy(emailTemplateDao, globalMailConfiguration, sentEmailInfoDao);
    }


    @Bean
    public ActivatePromoTaskTaskExecutor pleaseComeBackEmailTaskExecutor(PromoService promoService) {
        return new ActivatePromoTaskTaskExecutor(promoService);
    }
}
