package ru.yandex.chemodan.app.psbilling.core.config.tasks;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.psbilling.core.billing.users.CheckOrderTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.CheckRefundTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.CheckUserServiceTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.RefundOrderTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.TrustRefundService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserBillingService;
import ru.yandex.chemodan.app.psbilling.core.billing.users.UserUpgradeTask;
import ru.yandex.chemodan.app.psbilling.core.billing.users.processors.OrderProcessorFacade;
import ru.yandex.chemodan.app.psbilling.core.config.PsBillingCoreConfiguration;
import ru.yandex.chemodan.app.psbilling.core.dao.users.OrderDao;
import ru.yandex.chemodan.app.psbilling.core.tasks.execution.TaskScheduler;
import ru.yandex.chemodan.app.psbilling.core.users.UserServiceManager;

@Configuration
@Import({
        PsBillingCoreConfiguration.class
})
public class UserBillingTasksConfiguration {
    @Bean
    public CheckOrderTask checkOrderTask(OrderProcessorFacade orderProcessorFacade) {
        return new CheckOrderTask(orderProcessorFacade);
    }

    @Bean
    public CheckRefundTask checkRefundTask(TrustRefundService trustRefundService) {
        return new CheckRefundTask(trustRefundService);
    }

    @Bean
    public UserUpgradeTask userUpgradeTask(UserServiceManager userServiceManager, OrderDao orderDao) {
        return new UserUpgradeTask(userServiceManager, orderDao);
    }

    @Bean
    public RefundOrderTask refundOrderTask(
            UserBillingService userBillingService, TaskScheduler taskScheduler, OrderDao orderDao) {
        return new RefundOrderTask(userBillingService, taskScheduler, orderDao);
    }

    @Bean
    public CheckUserServiceTask checkUserServiceTask(UserServiceManager userServiceManager,
                                                     OrderProcessorFacade orderProcessorFacade) {
        return new CheckUserServiceTask(userServiceManager, orderProcessorFacade);
    }
}
