package ru.yandex.chemodan.app.psbilling.core.converter;

import java.util.UUID;
import java.util.function.Function;

import lombok.Data;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoPayloadDao;
import ru.yandex.chemodan.app.psbilling.core.promos.PromoPayloadParser;

@RequiredArgsConstructor
public class ToPromoPayloadConverter implements Function<ToPromoPayloadConverter.ConvertData, Option<String>> {

    private final PromoPayloadDao promoPayloadDao;
    private final PromoPayloadParser promoPayloadParser;

    @Override
    public Option<String> apply(ConvertData convertData) {
        return convertData.payloadType
                .flatMapO(pt -> promoPayloadDao.get(convertData.promoId, pt, convertData.payloadVersion))
                .map(payload -> promoPayloadParser.processPayload(payload.getContent(), convertData.language, false));
    }

    @Data(staticConstructor = "cons")
    public static class ConvertData {
        private final UUID promoId;
        private final Option<String> payloadType;
        private final Option<Integer> payloadVersion;
        private final String language;
    }
}
