package ru.yandex.chemodan.app.psbilling.core.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Nonnull;

import org.intellij.lang.annotations.Language;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public abstract class AbstractPKBasedDAOImpl<T, PK> implements AbstractPKBasedDAO<T, PK> {
    protected final JdbcTemplate3 jdbcTemplate;
    @Language("SQL")
    private final String query;
    @Language("SQL")
    private final String queryForUpdate;

    public AbstractPKBasedDAOImpl(JdbcTemplate3 jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        query = initQuery();
        queryForUpdate = query + " for update";
    }

    //one column only for now
    abstract protected String pkColumnName();

    @Override
    public Option<T> findByIdO(PK id) {
        return jdbcTemplate.queryForOption(query, (rs, rowNum) -> parseRow(rs), pkToQueryParams(id));
    }

    @Override
    public Option<T> findAndLockByIdO(PK id) {
        return jdbcTemplate.queryForOption(queryForUpdate, (rs, rowNum) -> parseRow(rs), pkToQueryParams(id));
    }

    @Nonnull
    @Override
    public T findById(PK id) {
        return jdbcTemplate.queryForObject(query, (rs, rowNum) -> parseRow(rs), pkToQueryParams(id));
    }

    protected Object[] pkToQueryParams(PK id) {
        return new Object[]{id};
    }

    private String initQuery() {
        StringBuilder query = new StringBuilder("select * from \"").append(getTableName()).append("\"\nwhere 1=1");
        query.append("\n and \"").append(pkColumnName()).append("\" = ?");
        return query.toString();
    }

    @Override
    public ListF<T> findAll() {
        return jdbcTemplate.query("select * from " + getTableName(), (rs, rowNum) -> parseRow(rs));
    }

    public abstract String getTableName();

    public abstract T parseRow(ResultSet rs) throws SQLException;

    public T parseRowTranslated(ResultSet rs) {
        try {
            return parseRow(rs);
        } catch (SQLException e) {
            throw ExceptionUtils.translate(e);
        }
    }
}
