package ru.yandex.chemodan.app.psbilling.core.dao.admin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.admin.InappMigrationService;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.entities.admin.InappMigration;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;


public class InappMigrationDao extends AbstractDaoImpl<InappMigration> {
    public InappMigrationDao(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String getTableName() {
        return "inapp_migrations";
    }

    @Override
    public InappMigration parseRow(ResultSet rs) throws SQLException {
        return new InappMigration(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                PassportUid.cons(rs.getLong("uid")),
                rs.getString("status"),
                UUID.fromString(rs.getString("order_id")),
                rs.getString("current_product_period_code"),
                Optional.ofNullable(rs.getString("target_product_period_code")));
    }



    public InappMigration create(PassportUid uid, UUID orderId, String status, String currentProductPeriod) {
        MapF<String, Object> params = Cf.hashMap();
        Instant now = Instant.now();
        params.put("created_at", now);
        params.put("updated_at", now);
        params.put("uid", uid.getUid());
        params.put("order_id", orderId);
        params.put("status", status);
        params.put("current_product_period", currentProductPeriod);

        return jdbcTemplate.query(
                "INSERT INTO inapp_migrations (created_at, updated_at, uid, order_id, status, current_product_period_code) " +
                        "VALUES (:created_at, :updated_at, :uid, :order_id, :status, :current_product_period) " +
                        " RETURNING *",
                (rs, num) -> parseRow(rs), params).first();
    }
    public InappMigration setStatus(UUID id, InappMigrationService.MigrationStatus status) {
        return setStatus(id, status.name());
    }

    public InappMigration setStatus(UUID id, String status) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("id", id);
        params.put("status", status);
        params.put("updated_at", Instant.now());
        return jdbcTemplate.query(
                "UPDATE inapp_migrations set status = :status, " +
                        " updated_at = :updated_at" +
                        " where id = :id " +
                        " RETURNING *",
                (rs, num) -> parseRow(rs), params).first();
    }

    public InappMigration setTargetProductPeriodCode(UUID id, String targetProductPeriodCode) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("id", id);
        params.put("updated_at", Instant.now());
        params.put("target_product_period_code", targetProductPeriodCode);
        return jdbcTemplate.query(
                "UPDATE inapp_migrations set target_product_period_code = :target_product_period_code, " +
                        " updated_at = :updated_at" +
                        " where id = :id " +
                        " RETURNING *",
                (rs, num) -> parseRow(rs), params).first();
    }
}
