package ru.yandex.chemodan.app.psbilling.core.dao.cards;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.cards.CardEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.cards.CardPurpose;
import ru.yandex.chemodan.app.psbilling.core.entities.cards.CardStatus;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface CardDao extends AbstractDao<CardEntity> {
    Option<CardEntity> findByExternalId(PassportUid uid, String externalId);

    ListF<CardEntity> findByPurpose(PassportUid uid, CardPurpose purpose);

    Option<CardEntity> findB2BPrimary(PassportUid uid);

    ListF<CardEntity> findCardsByUid(PassportUid uid);

    CardEntity insert(InsertData insertData);

    CardEntity insertOrUpdateStatus(InsertData insertData);

    // добавляет новую карту, если нет такого external_id,
    // иначе обновляет статус и,
    // если карта была primary, а теперь есть другая активная primary карта,
    // то меняет purpose на b2b
    CardEntity insertOrUpdateStatusWithCheckingOtherPrimary(InsertData insertData);

    CardEntity setB2BPrimaryCard(PassportUid uid, String externalId);

    Option<CardEntity> updatePurpose(PassportUid uid, String externalId, CardPurpose purpose);

    void updateStatus(UUID id, CardStatus newStatus);

    Option<CardEntity> updateStatusAndPurpose(UUID id, CardStatus status, CardPurpose purpose);

    void updateStatus(ListF<String> externalIds, CardStatus newStatus);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<CardEntity> {
        private final PassportUid uid;
        private final CardPurpose purpose;
        private final String externalId;
        private final CardStatus status;
    }

}
