package ru.yandex.chemodan.app.psbilling.core.dao.cards;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.cards.CardBindingStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.cards.TrustCardBinding;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface TrustCardBindingDao extends AbstractDao<TrustCardBinding> {

    TrustCardBinding insert(InsertData dataToInsert);

    Option<TrustCardBinding> setTransactionId(UUID id, String transactionId);

    Option<TrustCardBinding> updateStatusIfInNotSuccess(TrustCardBinding trustCardBinding);

    Option<TrustCardBinding> findByTransactionId(String transactionId);

    ListF<TrustCardBinding> findInitBindings(Instant createdBefore,
                                             int batchSize, Option<UUID> idFrom);

    int countStaleRecords(Duration duration);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<TrustCardBinding> {
        private final CardBindingStatus status;
        private final PassportUid operatorUid;

        @Builder.Default
        private final Option<String> transactionId = Option.empty();
        @Builder.Default
        private final Option<String> error = Option.empty();
        @Builder.Default
        private final Option<UUID> cardId = Option.empty();
    }
}
