package ru.yandex.chemodan.app.psbilling.core.dao.features;

import java.util.Map;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureCallbackContext;
import ru.yandex.misc.lang.DefaultObject;

public interface FeatureCallbackContextDao extends AbstractDao<FeatureCallbackContext> {
    void updateData(UUID id, Map<String, Object> data);

    FeatureCallbackContext insertOrUpdate(InsertData insertData);

    Option<FeatureCallbackContext> findByUidAndFeature(String uid, UUID featureId);

    Option<FeatureCallbackContext> findByGroupAndFeature(UUID groupId, UUID featureId);

    void deleteByUidAndFeature(String uid, UUID featureId);

    void deleteByGroupAndFeature(UUID groupId, UUID featureId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<FeatureCallbackContext> {
        @Builder.Default
        private final Option<String> uid = Option.empty();
        @Builder.Default
        private final Option<UUID> groupId = Option.empty();
        private final UUID featureId;
    }
}
