package ru.yandex.chemodan.app.psbilling.core.dao.features;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.chemodan.app.psbilling.core.entities.features.GroupFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.features.GroupServiceFeature;

public interface GroupServiceFeatureDao
        extends ServiceFeatureDao<GroupServiceFeature, UUID, GroupServiceFeatureDao.InsertData, GroupFeature> {
    @Builder
    @Getter
    class InsertData extends ServiceFeatureDao.InsertData<UUID, GroupServiceFeature> {
        private final UUID groupServiceId;
        private final UUID productFeatureId;
        private final UUID productTemplateFeatureId;
        private final UUID groupId;

        @Override
        public UUID getParentServiceId() {
            return groupServiceId;
        }

        @Override
        public UUID getOwnerId() {
            return groupId;
        }
    }
}
