package ru.yandex.chemodan.app.psbilling.core.dao.features;

import java.util.UUID;

import com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.features.FeatureWithOwner;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ChildSynchronizableRecordDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizableRecord;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.lang.DefaultObject;

public interface ServiceFeatureDao<TFeature extends SynchronizableRecord,
        TOwner,
        TInsertData extends ServiceFeatureDao.InsertData<TOwner, TFeature>,
        TFeatureWithOwner extends FeatureWithOwner<TOwner>>
        extends AbstractDao<TFeature>, ChildSynchronizableRecordDao<TFeature, TInsertData> {
    @VisibleForTesting
    TFeature insert(TInsertData insertData, Target target);

    ListF<TFeature> findAndLockEnabledOrNotActual(TOwner ownerId, UUID featureId, UUID lockId, Duration lockTime);

    ListF<TFeatureWithOwner> findForSynchronization();

    ListF<TFeatureWithOwner> findForSynchronization(UUID parentServiceId);

    int countNotActualUpdatedBefore(Duration triggeredBefore);

    void setStatusActualAndUnlock(UUID lockId, MapF<UUID, Target> idsAndTarget);

    void snoozeSynchronization(ListF<UUID> ids, Instant delayUntil);

    @VisibleForTesting
    void setStatusActual(UUID id, Target withTarget);

    @VisibleForTesting
    default void setTargetState(UUID id, Target target) {
        setTargetState(Cf.list(id), target);
    }

    void unlock(UUID lockId);

    abstract class InsertData<TOwner, TInsertData extends AbstractEntity> extends DefaultObject implements InsertingData<TInsertData> {
        public abstract UUID getParentServiceId();

        public abstract UUID getProductFeatureId();

        public abstract UUID getProductTemplateFeatureId();

        public abstract TOwner getOwnerId();
    }
}
