package ru.yandex.chemodan.app.psbilling.core.dao.features;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.chemodan.app.psbilling.core.entities.features.UserFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.features.UserServiceFeature;

public interface UserServiceFeatureDao
        extends ServiceFeatureDao<UserServiceFeature, String, UserServiceFeatureDao.InsertData, UserFeature> {

    @Builder
    @Getter
    class InsertData extends ServiceFeatureDao.InsertData<String, UserServiceFeature> {
        private final UUID userServiceId;
        private final UUID productFeatureId;
        private final UUID productTemplateFeatureId;
        private final String uid;

        @Override
        public UUID getParentServiceId() {
            return userServiceId;
        }

        @Override
        public String getOwnerId() {
            return uid;
        }
    }
}
