package ru.yandex.chemodan.app.psbilling.core.dao.features.impl;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.features.GroupServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.entities.features.GroupFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.features.GroupServiceFeature;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class GroupServiceFeatureDaoImpl
        extends AbstractServiceFeatureDao<GroupServiceFeature, UUID, GroupServiceFeatureDao.InsertData, GroupFeature>
        implements GroupServiceFeatureDao {
    public GroupServiceFeatureDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate, "group_service_id", "group_id", GroupFeature::new);
    }

    @Override
    public String getTableName() {
        return "group_service_features";
    }

    @Override
    public GroupServiceFeature create(UUID id, Instant createdAt, Target target, Instant targetUpdatedAt,
                                      SynchronizationStatus status, Instant statusUpdatedAt,
                                      Option<Instant> actualEnabledAt, Option<Instant> actualDisabledAt,
                                      UUID parentServiceId, UUID productFeatureId, UUID ownerId,
                                      Option<Instant> nextTry, Option<UUID> productTemplateFeatureId) {
        return new GroupServiceFeature(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt,
                actualEnabledAt, actualDisabledAt, parentServiceId, productFeatureId, ownerId, nextTry,
                productTemplateFeatureId);
    }
}
