package ru.yandex.chemodan.app.psbilling.core.dao.features.impl;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.features.UserServiceFeatureDao;
import ru.yandex.chemodan.app.psbilling.core.entities.features.UserFeature;
import ru.yandex.chemodan.app.psbilling.core.entities.features.UserServiceFeature;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class UserServiceFeatureDaoImpl
        extends AbstractServiceFeatureDao<UserServiceFeature, String, UserServiceFeatureDao.InsertData, UserFeature>
        implements UserServiceFeatureDao {
    public UserServiceFeatureDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate, "user_service_id", "uid", UserFeature::new);
    }

    @Override
    public String getTableName() {
        return "user_service_features";
    }

    @Override
    public UserServiceFeature create(UUID id, Instant createdAt, Target target, Instant targetUpdatedAt,
                                      SynchronizationStatus status, Instant statusUpdatedAt,
                                      Option<Instant> actualEnabledAt, Option<Instant> actualDisabledAt,
                                      UUID parentServiceId, UUID productFeatureId, String ownerId,
                                      Option<Instant> nextTry, Option<UUID> productTemplateFeatureId) {
        return new UserServiceFeature(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt,
                actualEnabledAt, actualDisabledAt, parentServiceId, productFeatureId, ownerId, nextTry,
                productTemplateFeatureId);
    }
}
