package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.UUID;

import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.CalculationStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.DistributionServiceTransactionCalculation;

public interface DistributionPlatformCalculationDao {
    ListF<DistributionServiceTransactionCalculation> lock(LocalDate calcMonth);

    default boolean updateStatus(UUID taskId, CalculationStatus previousStatus,
                                 CalculationStatus newStatus) {
        return updateStatus(taskId, Cf.list(previousStatus), newStatus);
    }

    boolean updateStatus(UUID taskId,
                         CollectionF<CalculationStatus> previousStatuses,
                         CalculationStatus newStatus);

    DistributionServiceTransactionCalculation initCalculation(LocalDate calcMonth, Long clientId, UUID taskId, String bazingaJobId);

    DistributionServiceTransactionCalculation find(UUID jobId);

    void setCalculationObsolete(LocalDate calcMonth);
}
