package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;
import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.YtExportRow;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.DistributionPlatformTransactionEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface DistributionPlatformTransactionsDao {
    void batchInsert(CollectionF<InsertData> transactions);

    int removeCalculations(LocalDate month, int batchSize);

    ListF<DistributionPlatformTransactionEntity> findTransactions(LocalDate month, Option<UUID> groupIdGreaterThan,
                                                                  int batchSize);

    ListF<ExportRow> findExportRows(LocalDate month);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<DistributionPlatformTransactionEntity> {
        private final LocalDate calcMonth;
        private final UUID groupId;
        private final BigDecimal paidUserCount;
        private final BigDecimal amount;
        private final String clid;
        private final Currency currency;
        private final String actId;
    }

    @AllArgsConstructor
    @Getter
    class ExportRow extends DefaultObject implements YtExportRow {
        private static final BigDecimal SECONDS_IN_DAY = BigDecimal.valueOf(60 * 60 * 24);
        private final LocalDate billingPeriod;
        private final String clid;
        private final BigDecimal userSecondsCount;
        private final BigDecimal money;
        private final String currency;
        private final String productId;

        @Override
        public UUID getId() {
            return null; // нужен для батчевой выгрузки, чтобы понимать с какого id надо начинать в след батче
        }

        public String getCount() {
            return userSecondsCount.divide(SECONDS_IN_DAY, RoundingMode.DOWN).setScale(0, RoundingMode.DOWN).toString();
        }
    }
}
