package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.model.TimeIntervalCondition;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.BalancePaymentInfo;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.InstantInterval;

public interface GroupDao extends AbstractDao<Group> {
    default Option<Group> findGroup(@Nonnull GroupType groupType, @Nonnull String externalId){
        return findGroup(groupType, externalId, null);
    }

    Option<Group> findGroup(@Nonnull GroupType groupType, @Nonnull String externalId, @Nullable UUID parentGroupId);

    Group updatePaymentInfo(UUID uid, BalancePaymentInfo paymentInfo);

    void setAutoBillingForClient(Long clientId, boolean b2bAutoBillingEnabled);

    Group insert(InsertData dataToInsert);

    void updateStatus(UUID groupId, GroupStatus newStatus);

    void updateMembersSynchronizationStatus(UUID groupId, boolean synchronizationStopped);

    Group lockGroup(UUID groupId);

    SetF<String> findGroupProductCodesWithActiveServicesByExternalGroupIds(GroupType type,
                                                                           CollectionF<String> groupExternalIds);

    void insertAgreement(UUID groupId, UUID productOwnerId);

    void removePaymentInfo(UUID groupId);

    ListF<Group> filterGroupsByAcceptedAgreement(GroupType groupType, ListF<String> groupExternalIds,
                                                 UUID productOwner);

    ListF<Group> getGroupsToCheckForUid(PassportUid uid, int batchSize, GroupType groupType,
                                        Option<UUID> greaterThan);

    ListF<PassportUid> findUidsToCheckBillingStatus(int batchSize, GroupType groupType,
                                                    Option<PassportUid> greaterThan);

    ListF<Group> findGroups(ListF<UUID> groupIds);

    Option<Group> getParentGroup(UUID childGroupId);

    ListF<Group> getChildGroups(UUID parentGroupId);

    // TODO reduce data
    ListF<Group> findGroupsWithClid(int batchSize, GroupType groupType,
                                    Option<TimeIntervalCondition> billingDateIntervalCondition,
                                    Option<UUID> greaterThan);

    ListF<Group> findGroupsWithActivePrepaidService(
            InstantInterval balanceVoidInterval, Option<UUID> groupMinId, int batchSize);

    Group findByPaymentRequestId(UUID requestId);

    ListF<Group> findGroupsByPaymentInfoUid(PassportUid uid);

    ListF<Group> findGroupsByPaymentInfoClient(Long clientId);

    boolean updateGroupNextSyncTimeIfNotChanged(UUID groupId, Instant oldNextSyncTime, Instant newNextSyncTime);

    void updateGroupNextSyncTime(UUID groupId, Instant newNextSyncTime);

    int mixpaidClientsCount();

    ListF<Group> findGroupsWithDisabledPrepaidGsAndNoActiveGs(
            InstantInterval balanceVoidInterval, Option<UUID> groupMinId, int batchSize);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<Group> {
        private final String externalId;
        private final GroupType type;
        private final PassportUid ownerUid;
        private final BalancePaymentInfo paymentInfo;
        private final Duration gracePeriod;
        private final boolean synchronizationStopped;
        private final Option<String> clid;
        @Builder.Default
        private final Option<UUID> parentGroupId = Option.empty();
    }
}
